/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.common.entity;

import com.teamabnormals.pet_cemetery.core.registry.PCEntityTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.level.Level;

public class SkeletonCat
extends Cat {
    public SkeletonCat(EntityType<? extends SkeletonCat> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Cat.createAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.3500000238418579).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    public SkeletonCat getBreedOffspring(ServerLevel world, AgeableMob ageableMob) {
        SkeletonCat cat = (SkeletonCat)((EntityType)PCEntityTypes.SKELETON_CAT.get()).create((Level)world);
        if (cat != null && ageableMob instanceof Cat) {
            Cat parent = (Cat)ageableMob;
            cat.setVariant(this.random.nextBoolean() ? this.getVariant() : parent.getVariant());
            if (this.isTame()) {
                cat.setOwnerUUID(this.getOwnerUUID());
                cat.setTame(true, true);
                cat.setCollarColor(this.random.nextBoolean() ? this.getCollarColor() : parent.getCollarColor());
            }
        }
        return cat;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.SKELETON_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SKELETON_DEATH;
    }
}

