/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.common.entity;

import com.teamabnormals.pet_cemetery.core.registry.PCEntityTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.level.Level;

public class SkeletonWolf
extends Wolf {
    public SkeletonWolf(EntityType<? extends SkeletonWolf> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Wolf.createAttributes().add(Attributes.MOVEMENT_SPEED, 0.3500000238418579).add(Attributes.MAX_HEALTH, 6.0).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(30.0);
            this.setHealth(30.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(6.0);
        }
    }

    public SkeletonWolf getBreedOffspring(ServerLevel world, AgeableMob ageableMob) {
        SkeletonWolf wolf = (SkeletonWolf)((EntityType)PCEntityTypes.SKELETON_WOLF.get()).create((Level)world);
        if (wolf != null && ageableMob instanceof Wolf) {
            Wolf parent = (Wolf)ageableMob;
            wolf.setVariant(this.random.nextBoolean() ? this.getVariant() : parent.getVariant());
            if (this.isTame()) {
                wolf.setOwnerUUID(this.getOwnerUUID());
                wolf.setTame(true, true);
                wolf.setCollarColor(this.random.nextBoolean() ? this.getCollarColor() : parent.getCollarColor());
            }
        }
        return wolf;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.SKELETON_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SKELETON_DEATH;
    }

    public float getWetShade(float partialTicks) {
        return 1.0f;
    }
}

