/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.common.entity;

import com.teamabnormals.pet_cemetery.common.entity.ZombiePet;
import com.teamabnormals.pet_cemetery.core.registry.PCEntityTypes;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ZombieCat
extends Cat
implements ZombiePet {
    private static final EntityDataAccessor<Boolean> CONVERTING = SynchedEntityData.defineId(ZombieCat.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int conversionTime;
    private UUID conversionStarter;

    public ZombieCat(EntityType<? extends ZombieCat> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Cat.createAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    @Override
    public EntityType<? extends LivingEntity> getConversionType() {
        return EntityType.CAT;
    }

    public ZombieCat getBreedOffspring(ServerLevel level, AgeableMob ageableMob) {
        ZombieCat cat = (ZombieCat)((EntityType)PCEntityTypes.ZOMBIE_CAT.get()).create((Level)level);
        if (cat != null && ageableMob instanceof Cat) {
            Cat parent = (Cat)ageableMob;
            cat.setVariant(this.random.nextBoolean() ? this.getVariant() : parent.getVariant());
            if (this.isTame()) {
                cat.setOwnerUUID(this.getOwnerUUID());
                cat.setTame(true, true);
                cat.setCollarColor(this.random.nextBoolean() ? this.getCollarColor() : parent.getCollarColor());
            }
        }
        return cat;
    }

    public Cat finalizeConversionSpawn(ServerLevel level) {
        Cat cat = (Cat)this.convertTo(EntityType.CAT, false);
        if (cat != null) {
            cat.setCollarColor(this.getCollarColor());
            cat.setTame(this.isTame(), true);
            cat.setOrderedToSit(this.isOrderedToSit());
            if (this.getOwner() != null) {
                cat.setOwnerUUID(this.getOwner().getUUID());
            }
            cat.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(cat.blockPosition()), MobSpawnType.CONVERSION, null);
            cat.setVariant(this.getVariant());
        }
        return cat;
    }

    @Override
    public int getConversionTime() {
        return this.conversionTime;
    }

    @Override
    public void setConversionTime(int conversionTime) {
        this.conversionTime = conversionTime;
    }

    @Override
    public UUID getConversionStarter() {
        return this.conversionStarter;
    }

    @Override
    public void setConversionStarter(UUID conversionStarter) {
        this.conversionStarter = conversionStarter;
    }

    @Override
    public EntityDataAccessor<Boolean> getConversionData() {
        return CONVERTING;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.defineConvertingSynchedData(builder);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.addConvertingSavaData(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.readConvertingSavaData(tag);
    }

    public void tick() {
        this.tickConversionProgress();
        super.tick();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult result = this.attemptCureZombie(player, hand);
        return result.indicateItemUse() ? result : super.mobInteract(player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (!this.playCureSound(id)) {
            super.handleEntityEvent(id);
        }
    }
}

