/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.common.item;

import com.teamabnormals.pet_cemetery.core.other.tags.PCEntityTypeTags;
import com.teamabnormals.pet_cemetery.core.registry.PCDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.text.WordUtils;

public class PetCollarItem
extends Item {
    public PetCollarItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag = ((CustomData)stack.getOrDefault((DataComponentType)PCDataComponents.PET_DATA.get(), (Object)CustomData.EMPTY)).copyTag();
        if (tag.contains("PetID")) {
            String petID = tag.getString("PetID");
            EntityType pet = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)petID));
            tooltip.add((Component)Component.translatable((String)pet.getDescriptionId()).withStyle(ChatFormatting.GRAY));
            if (tag.contains("PetVariant")) {
                String texture = "";
                if (pet.is(PCEntityTypeTags.CATS)) {
                    ResourceLocation catVariant = ResourceLocation.parse((String)tag.getString("PetVariant"));
                    texture = catVariant.getPath();
                }
                if (pet.is(PCEntityTypeTags.PARROTS)) {
                    texture = Parrot.Variant.byId((int)tag.getInt("PetVariant")).getSerializedName();
                }
                if (pet.is(PCEntityTypeTags.WOLVES)) {
                    ResourceLocation wolfVariant = ResourceLocation.parse((String)tag.getString("PetVariant"));
                    texture = wolfVariant.getPath();
                }
                texture = texture.replace("_", " ").concat(" ");
                tooltip.add((Component)Component.literal((String)WordUtils.capitalize((String)texture)).withStyle(ChatFormatting.GRAY));
            }
            if (tag.getBoolean("IsChild")) {
                tooltip.add((Component)Component.translatable((String)"tooltip.pet_cemetery.baby").withStyle(ChatFormatting.GRAY));
            }
        }
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    public int getColor(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault((DataComponentType)PCDataComponents.PET_DATA.get(), (Object)CustomData.EMPTY)).copyTag();
        DyeColor color = tag.contains("CollarColor") ? DyeColor.byId((int)tag.getInt("CollarColor")) : DyeColor.RED;
        return color.getTextureDiffuseColor();
    }
}

