/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.core.data.client;

import com.teamabnormals.blueprint.core.data.client.BlueprintLanguageProvider;
import com.teamabnormals.pet_cemetery.core.registry.PCEntityTypes;
import com.teamabnormals.pet_cemetery.core.registry.PCItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;

public class PCLanguageProvider
extends BlueprintLanguageProvider {
    public PCLanguageProvider(PackOutput output) {
        super(output, "pet_cemetery");
    }

    public void addTranslations() {
        this.add(new Item[]{(Item)PCItems.PET_COLLAR.get()});
        this.add(new Item[]{(Item)PCItems.ZOMBIE_WOLF_SPAWN_EGG.get(), (Item)PCItems.ZOMBIE_CAT_SPAWN_EGG.get(), (Item)PCItems.ZOMBIE_PARROT_SPAWN_EGG.get(), (Item)PCItems.SKELETON_WOLF_SPAWN_EGG.get(), (Item)PCItems.SKELETON_CAT_SPAWN_EGG.get(), (Item)PCItems.SKELETON_PARROT_SPAWN_EGG.get()});
        this.add((EntityType)PCEntityTypes.ZOMBIE_WOLF.get(), (EntityType)PCEntityTypes.ZOMBIE_CAT.get(), (EntityType)PCEntityTypes.ZOMBIE_PARROT.get(), (EntityType)PCEntityTypes.SKELETON_WOLF.get(), (EntityType)PCEntityTypes.SKELETON_CAT.get(), (EntityType)PCEntityTypes.SKELETON_PARROT.get());
        this.add("tooltip.pet_cemetery.baby", "Baby");
        this.addAdvancement("nether.respawned_pet", "Frankenweenie", "Respawn a pet using a Pet Collar at a Respawn Anchor");
        this.addAdvancement("nether.cured_zombie_pet", "Zombie Veterinarian", "Weaken and then cure a Zombie pet");
        this.addAdvancement("nether.respawned_zombie_pet", "Grim Reaper", "Respawn a Zombie pet as a Skeleton");
    }

    private void add(EntityType<?> ... entries) {
        for (EntityType<?> entry : entries) {
            this.add(entry, this.format(BuiltInRegistries.ENTITY_TYPE.getKey(entry)));
        }
    }

    private void addAdvancement(String key, String title, String description) {
        String intro = "advancements.pet_cemetery." + key + ".";
        this.add(intro + "title", title);
        this.add(intro + "description", description);
    }
}

