/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.core.data.server;

import com.teamabnormals.pet_cemetery.common.advancement.ConvertedMobTrigger;
import com.teamabnormals.pet_cemetery.core.PetCemetery;
import com.teamabnormals.pet_cemetery.core.other.tags.PCEntityTypeTags;
import com.teamabnormals.pet_cemetery.core.registry.PCDataComponents;
import com.teamabnormals.pet_cemetery.core.registry.PCItems;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class PCAdvancementProvider
implements AdvancementProvider.AdvancementGenerator {
    public static AdvancementProvider create(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper helper) {
        return new AdvancementProvider(output, provider, helper, List.of(new PCAdvancementProvider()));
    }

    public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
        ItemStack stack = new ItemStack((ItemLike)PCItems.PET_COLLAR.get());
        CompoundTag tag = new CompoundTag();
        PCAdvancementProvider.createAdvancement("respawned_pet", "nether", ResourceLocation.withDefaultNamespace((String)"nether/charge_respawn_anchor"), stack, AdvancementType.TASK, true, true, false).addCriterion("respawned_pet", ConvertedMobTrigger.TriggerInstance.respawnedPet()).save(consumer, "pet_cemetery:nether/respawned_pet");
        tag.putInt("CollarColor", DyeColor.GREEN.getId());
        stack.set((DataComponentType)PCDataComponents.PET_DATA.get(), (Object)CustomData.of((CompoundTag)tag));
        PCAdvancementProvider.createAdvancement("cured_zombie_pet", "nether", PetCemetery.location("nether/respawned_pet"), stack, AdvancementType.GOAL, true, true, false).addCriterion("cured_zombie_pet", ConvertedMobTrigger.TriggerInstance.curedZombiePet()).save(consumer, "pet_cemetery:nether/cured_zombie_pet");
        tag.putInt("CollarColor", DyeColor.WHITE.getId());
        stack.set((DataComponentType)PCDataComponents.PET_DATA.get(), (Object)CustomData.of((CompoundTag)tag));
        PCAdvancementProvider.createAdvancement("respawned_zombie_pet", "nether", PetCemetery.location("nether/respawned_pet"), stack, AdvancementType.TASK, true, true, false).addCriterion("respawned_zombie_pet", ConvertedMobTrigger.TriggerInstance.respawnedPet(Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(PCEntityTypeTags.SKELETON_PETS))))).save(consumer, "pet_cemetery:nether/respawned_zombie_pet");
    }

    private static Advancement.Builder createAdvancement(String name, String category, ResourceLocation parent, ItemStack icon, AdvancementType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return Advancement.Builder.advancement().parent(Advancement.Builder.advancement().build(parent)).display(icon, (Component)Component.translatable((String)("advancements.pet_cemetery." + category + "." + name + ".title")), (Component)Component.translatable((String)("advancements.pet_cemetery." + category + "." + name + ".description")), null, frame, showToast, announceToChat, hidden);
    }
}

