/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.core.other;

import com.google.common.collect.Lists;
import com.teamabnormals.pet_cemetery.common.advancement.ConvertedMobTrigger;
import com.teamabnormals.pet_cemetery.core.other.PCCriteriaTriggers;
import com.teamabnormals.pet_cemetery.core.other.tags.PCEntityTypeTags;
import com.teamabnormals.pet_cemetery.core.registry.PCDataComponents;
import com.teamabnormals.pet_cemetery.core.registry.PCEntityTypes;
import com.teamabnormals.pet_cemetery.core.registry.PCItems;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="pet_cemetery")
public class PCEvents {
    @SubscribeEvent
    public static void onLivingSpawned(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        EntityType entityType = entity.getType();
        if ((entityType.is(PCEntityTypeTags.ZOMBIE_PETS) || entityType.is(PCEntityTypeTags.SKELETON_PETS)) && entity instanceof TamableAnimal) {
            TamableAnimal pet = (TamableAnimal)entity;
            ArrayList goalsToRemove = Lists.newArrayList();
            pet.goalSelector.getAvailableGoals().forEach(goal -> {
                if (goal.getGoal() instanceof FloatGoal) {
                    goalsToRemove.add(goal.getGoal());
                }
            });
            goalsToRemove.forEach(arg_0 -> ((GoalSelector)pet.goalSelector).removeGoal(arg_0));
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        EntityType type = entity.getType();
        if (type.builtInRegistryHolder().getData(PCEntityTypes.RESPAWNABLE_PETS) != null) {
            TamableAnimal pet;
            ItemStack collar = new ItemStack((ItemLike)PCItems.PET_COLLAR.get());
            CompoundTag tag = new CompoundTag();
            tag.putString("PetID", BuiltInRegistries.ENTITY_TYPE.getKey((Object)type).toString());
            tag.putBoolean("IsChild", entity.isBaby());
            if (entity.hasCustomName()) {
                collar.set(DataComponents.CUSTOM_NAME, (Object)entity.getCustomName());
            }
            if (entity instanceof TamableAnimal && (pet = (TamableAnimal)entity).isTame()) {
                tag.putString("OwnerID", pet.getOwnerUUID().toString());
                if (entity instanceof Wolf) {
                    Wolf wolf = (Wolf)entity;
                    String variant = ((Registry)wolf.level().registryAccess().registry(Registries.WOLF_VARIANT).get()).getKey((Object)((WolfVariant)wolf.getVariant().value())).toString();
                    tag.putString("PetVariant", variant);
                    tag.putInt("CollarColor", wolf.getCollarColor().getId());
                } else if (entity instanceof Cat) {
                    Cat cat = (Cat)entity;
                    String variant = ((Registry)cat.level().registryAccess().registry(Registries.CAT_VARIANT).get()).getKey((Object)((CatVariant)cat.getVariant().value())).toString();
                    tag.putString("PetVariant", variant);
                    tag.putInt("CollarColor", cat.getCollarColor().getId());
                } else if (entity instanceof Parrot) {
                    Parrot parrot = (Parrot)entity;
                    tag.putInt("PetVariant", parrot.getVariant().getId());
                }
                collar.set((DataComponentType)PCDataComponents.PET_DATA.get(), (Object)CustomData.of((CompoundTag)tag));
                entity.spawnAtLocation(collar);
            } else if (entity.getType().is(PCEntityTypeTags.CAN_DROP_COLLAR_UNTAMED)) {
                collar.set((DataComponentType)PCDataComponents.PET_DATA.get(), (Object)CustomData.of((CompoundTag)tag));
                entity.spawnAtLocation(collar);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        ItemStack stack = event.getItemStack();
        BlockPos offsetPos = pos.above();
        if (stack.is((Item)PCItems.PET_COLLAR.get()) && state.is(Blocks.RESPAWN_ANCHOR) && level.dimensionType().respawnAnchorWorks() && (Integer)state.getValue((Property)RespawnAnchorBlock.CHARGE) > 0 && level.getBlockState(offsetPos).getCollisionShape((BlockGetter)level, offsetPos).isEmpty()) {
            Entity entity;
            PCEntityTypes.PetRespawn petRespawn;
            Optional entityHolder;
            Player player = event.getEntity();
            RandomSource random = player.getRandom();
            CompoundTag tag = ((CustomData)stack.getOrDefault((DataComponentType)PCDataComponents.PET_DATA.get(), (Object)CustomData.EMPTY)).copyTag();
            if (tag.contains("PetID") && (entityHolder = BuiltInRegistries.ENTITY_TYPE.getHolder(ResourceLocation.parse((String)tag.getString("PetID")))).isPresent() && (petRespawn = (PCEntityTypes.PetRespawn)((Holder.Reference)entityHolder.get()).getData(PCEntityTypes.RESPAWNABLE_PETS)) != null && (entity = ((EntityType)petRespawn.respawnedAs().value()).create(level)) instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                UUID owner = tag.contains("OwnerID") ? UUID.fromString(tag.getString("OwnerID")) : player.getUUID();
                DyeColor collarColor = DyeColor.byId((int)tag.getInt("CollarColor"));
                if (entity2 instanceof AgeableMob) {
                    AgeableMob ageable = (AgeableMob)entity2;
                    ageable.setBaby(tag.getBoolean("IsChild"));
                }
                entity2.setPos((double)((float)offsetPos.getX() + 0.5f), (double)offsetPos.getY(), (double)((float)offsetPos.getZ() + 0.5f));
                if (stack.has(DataComponents.CUSTOM_NAME)) {
                    entity2.setCustomName(stack.getHoverName());
                }
                if (entity2 instanceof TamableAnimal) {
                    TamableAnimal pet = (TamableAnimal)entity2;
                    pet.setTame(true, true);
                    pet.setOwnerUUID(owner);
                    TamableAnimal tamableAnimal = pet;
                    Objects.requireNonNull(tamableAnimal);
                    TamableAnimal tamableAnimal2 = tamableAnimal;
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Cat.class, Wolf.class, Parrot.class}, (Object)tamableAnimal2, n)) {
                        case 0: {
                            Cat cat = (Cat)tamableAnimal2;
                            Registry registry = level.registryAccess().registryOrThrow(Registries.CAT_VARIANT);
                            Optional variant = registry.getHolder(ResourceLocation.parse((String)tag.getString("PetVariant")));
                            if (!variant.isPresent()) break;
                            cat.setVariant((Holder)variant.get());
                            cat.setCollarColor(collarColor);
                            break;
                        }
                        case 1: {
                            Wolf wolf = (Wolf)tamableAnimal2;
                            Registry registry = level.registryAccess().registryOrThrow(Registries.WOLF_VARIANT);
                            Optional variant = registry.getHolder(ResourceLocation.parse((String)tag.getString("PetVariant")));
                            if (!variant.isPresent()) break;
                            wolf.setVariant((Holder)variant.get());
                            wolf.setCollarColor(collarColor);
                            break;
                        }
                        case 2: {
                            Parrot parrot = (Parrot)tamableAnimal2;
                            parrot.setVariant(Parrot.Variant.byId((int)tag.getInt("PetVariant")));
                            break;
                        }
                    }
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((ConvertedMobTrigger)((Object)PCCriteriaTriggers.RESPAWNED_PET.get())).trigger(serverPlayer, entity2, entity2);
                }
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)RespawnAnchorBlock.CHARGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)RespawnAnchorBlock.CHARGE) - 1)));
                for (int i = 0; i < 10; ++i) {
                    double d0 = random.nextGaussian() * 0.025;
                    double d1 = random.nextGaussian() * 0.025;
                    double d2 = random.nextGaussian() * 0.025;
                    level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, entity2.getRandomX(0.75), entity2.getRandomY(), entity2.getRandomZ(0.75), d0, d1, d2);
                }
                level.playSound(player, pos, (SoundEvent)SoundEvents.RESPAWN_ANCHOR_DEPLETE.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                level.addFreshEntity((Entity)entity2);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide));
            }
        }
    }
}

