/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.core.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.core.util.registry.EntitySubRegistryHelper;
import com.teamabnormals.pet_cemetery.common.entity.SkeletonCat;
import com.teamabnormals.pet_cemetery.common.entity.SkeletonParrot;
import com.teamabnormals.pet_cemetery.common.entity.SkeletonWolf;
import com.teamabnormals.pet_cemetery.common.entity.ZombieCat;
import com.teamabnormals.pet_cemetery.common.entity.ZombieParrot;
import com.teamabnormals.pet_cemetery.common.entity.ZombieWolf;
import com.teamabnormals.pet_cemetery.core.PetCemetery;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;

@EventBusSubscriber(modid="pet_cemetery", bus=EventBusSubscriber.Bus.MOD)
public class PCEntityTypes {
    public static final EntitySubRegistryHelper ENTITY_TYPES = (EntitySubRegistryHelper)PetCemetery.REGISTRY_HELPER.getEntitySubHelper();
    public static final DeferredHolder<EntityType<?>, EntityType<ZombieWolf>> ZOMBIE_WOLF = ENTITY_TYPES.createEntity("zombie_wolf", ZombieWolf::new, MobCategory.CREATURE, 0.6f, 0.85f);
    public static final DeferredHolder<EntityType<?>, EntityType<ZombieCat>> ZOMBIE_CAT = ENTITY_TYPES.createEntity("zombie_cat", ZombieCat::new, MobCategory.CREATURE, 0.6f, 0.7f);
    public static final DeferredHolder<EntityType<?>, EntityType<ZombieParrot>> ZOMBIE_PARROT = ENTITY_TYPES.createEntity("zombie_parrot", ZombieParrot::new, MobCategory.CREATURE, 0.5f, 0.9f);
    public static final DeferredHolder<EntityType<?>, EntityType<SkeletonWolf>> SKELETON_WOLF = ENTITY_TYPES.createEntity("skeleton_wolf", SkeletonWolf::new, MobCategory.CREATURE, 0.6f, 0.85f);
    public static final DeferredHolder<EntityType<?>, EntityType<SkeletonCat>> SKELETON_CAT = ENTITY_TYPES.createEntity("skeleton_cat", SkeletonCat::new, MobCategory.CREATURE, 0.6f, 0.7f);
    public static final DeferredHolder<EntityType<?>, EntityType<SkeletonParrot>> SKELETON_PARROT = ENTITY_TYPES.createEntity("skeleton_parrot", SkeletonParrot::new, MobCategory.CREATURE, 0.5f, 0.9f);
    public static final DataMapType<EntityType<?>, PetRespawn> RESPAWNABLE_PETS = DataMapType.builder((ResourceLocation)PetCemetery.location("respawnable_pets"), (ResourceKey)Registries.ENTITY_TYPE, PetRespawn.CODEC).synced(PetRespawn.RESPAWN_CODEC, false).build();

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ZOMBIE_WOLF.get(), ZombieWolf.createAttributes().build());
        event.put((EntityType)ZOMBIE_CAT.get(), ZombieCat.createAttributes().build());
        event.put((EntityType)ZOMBIE_PARROT.get(), ZombieParrot.createAttributes().build());
        event.put((EntityType)SKELETON_WOLF.get(), SkeletonWolf.createAttributes().build());
        event.put((EntityType)SKELETON_CAT.get(), SkeletonCat.createAttributes().build());
        event.put((EntityType)SKELETON_PARROT.get(), SkeletonParrot.createAttributes().build());
    }

    @SubscribeEvent
    public static void registerDataMaps(RegisterDataMapTypesEvent event) {
        event.register(RESPAWNABLE_PETS);
    }

    public record PetRespawn(Holder<EntityType<?>> respawnedAs) {
        public static final Codec<PetRespawn> RESPAWN_CODEC = RegistryFixedCodec.create((ResourceKey)Registries.ENTITY_TYPE).xmap(PetRespawn::new, PetRespawn::respawnedAs);
        public static final Codec<PetRespawn> CODEC = Codec.withAlternative((Codec)RecordCodecBuilder.create(in -> in.group((App)RegistryFixedCodec.create((ResourceKey)Registries.ENTITY_TYPE).fieldOf("respawned_as").forGetter(PetRespawn::respawnedAs)).apply((Applicative)in, PetRespawn::new)), RESPAWN_CODEC);
    }
}

