/*
 * Decompiled with CFR 0.152.
 */
package com.example.recallpotion;

import com.example.recallpotion.commands.RecallPotionCommand;
import com.example.recallpotion.listeners.CraftingListener;
import com.example.recallpotion.listeners.PlayerConsumeListener;
import com.example.recallpotion.listeners.PlayerInteractListener;
import com.example.recallpotion.managers.AdvancementManager;
import com.example.recallpotion.managers.ConfigManager;
import com.example.recallpotion.managers.RecipeManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class RecallPotionPlugin
extends JavaPlugin {
    private ConfigManager configManager;
    private RecipeManager recipeManager;
    private AdvancementManager advancementManager;

    public void onEnable() {
        this.configManager = new ConfigManager(this);
        this.recipeManager = new RecipeManager(this);
        this.advancementManager = new AdvancementManager(this);
        this.configManager.loadConfig();
        this.recipeManager.registerRecipes();
        this.advancementManager.registerAdvancements();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerInteractListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CraftingListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerConsumeListener(this), (Plugin)this);
        this.getCommand("recallpotion").setExecutor((CommandExecutor)new RecallPotionCommand(this));
        this.getLogger().info("RecallPotion plugin has been enabled!");
    }

    public void onDisable() {
        if (this.recipeManager != null) {
            this.recipeManager.unregisterRecipes();
        }
        if (this.advancementManager != null) {
            this.advancementManager.unregisterAdvancements();
        }
        this.getLogger().info("RecallPotion plugin has been disabled!");
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public RecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    public AdvancementManager getAdvancementManager() {
        return this.advancementManager;
    }
}

