/*
 * Decompiled with CFR 0.152.
 */
package com.example.recallpotion.listeners;

import com.example.recallpotion.RecallPotionPlugin;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class PlayerInteractListener
implements Listener {
    private final RecallPotionPlugin plugin;
    private final Random random = new Random();

    public PlayerInteractListener(RecallPotionPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getItem() != null && this.plugin.getRecipeManager().isRecallPotion(event.getItem())) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null && event.getClickedBlock().getType() == Material.END_PORTAL && event.getHand() == EquipmentSlot.HAND) {
            if (player.getLevel() >= this.plugin.getConfigManager().getXpCost()) {
                player.setLevel(player.getLevel() - this.plugin.getConfigManager().getXpCost());
                ItemStack recallPotion = this.plugin.getRecipeManager().createRecallPotion();
                player.getInventory().addItem(new ItemStack[]{recallPotion});
                player.sendMessage(this.plugin.getConfigManager().getMessage("portal-extract-success"));
                player.playSound(player.getLocation(), this.plugin.getConfigManager().getSound("portal-extract"), 1.0f, 1.0f);
                this.plugin.getAdvancementManager().grantPortalExtractAdvancement(player);
                event.setCancelled(true);
            } else {
                player.sendMessage(this.plugin.getConfigManager().getMessage("not-enough-xp"));
                event.setCancelled(true);
            }
        }
    }

    public void performRecallTeleport(Player player) {
        if (!player.hasPermission("recallpotion.use")) {
            player.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
            return;
        }
        Location homeLocation = player.getBedSpawnLocation();
        if (homeLocation == null) {
            homeLocation = player.getWorld().getSpawnLocation();
        }
        if (homeLocation == null) {
            player.sendMessage(this.plugin.getConfigManager().getMessage("no-home-set"));
            return;
        }
        Location departureLocation = player.getLocation().clone();
        Location finalHomeLocation = homeLocation;
        player.sendMessage(this.plugin.getConfigManager().getMessage("potion-used"));
        player.playSound(player.getLocation(), this.plugin.getConfigManager().getSound("potion-use"), 1.0f, 1.0f);
        this.createTeleportParticles(player, departureLocation, true);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            player.teleport(finalHomeLocation);
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.createTeleportParticles(player, player.getLocation(), false), 5L);
            this.plugin.getAdvancementManager().grantHomeReturnAdvancement(player);
        }, 20L);
    }

    private void createTeleportParticles(Player player, Location location, boolean scatter) {
        int count = 30;
        double speed = 0.1;
        for (int i = 0; i < count; ++i) {
            Vector velocity;
            double offsetX = (this.random.nextDouble() * 2.0 - 1.0) * 0.5;
            double offsetY = (this.random.nextDouble() * 2.0 - 1.0) * 0.5;
            double offsetZ = (this.random.nextDouble() * 2.0 - 1.0) * 0.5;
            Location particleLoc = location.clone().add(offsetX, offsetY + 1.0, offsetZ);
            if (scatter) {
                velocity = new Vector(this.random.nextDouble() * 2.0 - 1.0, this.random.nextDouble() * 2.0 - 1.0, this.random.nextDouble() * 2.0 - 1.0).normalize().multiply(speed);
            } else {
                Vector directionToPlayer = player.getEyeLocation().toVector().subtract(particleLoc.toVector()).normalize();
                velocity = directionToPlayer.multiply(speed);
            }
            player.spawnParticle(Particle.END_ROD, particleLoc, 0, velocity.getX(), velocity.getY(), velocity.getZ());
        }
    }
}

