/*
 * Decompiled with CFR 0.152.
 */
package com.example.recallpotion.managers;

import com.example.recallpotion.RecallPotionPlugin;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AdvancementManager {
    private final RecallPotionPlugin plugin;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private NamespacedKey homeReturnKey;
    private NamespacedKey portalExtractKey;

    public AdvancementManager(RecallPotionPlugin plugin) {
        this.plugin = plugin;
        this.homeReturnKey = new NamespacedKey((Plugin)plugin, "home_return");
        this.portalExtractKey = new NamespacedKey((Plugin)plugin, "portal_extract");
    }

    public void registerAdvancements() {
        String homeReturnJson = this.createAdvancementJson(this.plugin.getConfigManager().getAdvancementTitle("home-return"), this.plugin.getConfigManager().getAdvancementDescription("home-return"), this.plugin.getConfigManager().getAdvancementIcon("home-return"), this.plugin.getConfigManager().getAdvancementFrame("home-return"), this.plugin.getConfigManager().getAdvancementParent("home-return"));
        try {
            Bukkit.getUnsafe().loadAdvancement(this.homeReturnKey, homeReturnJson);
            this.plugin.getLogger().info("Registered advancement: " + this.homeReturnKey.getKey());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to load home_return advancement (already exists?): " + e.getMessage());
        }
        String portalExtractJson = this.createAdvancementJson(this.plugin.getConfigManager().getAdvancementTitle("portal-extract"), this.plugin.getConfigManager().getAdvancementDescription("portal-extract"), this.plugin.getConfigManager().getAdvancementIcon("portal-extract"), this.plugin.getConfigManager().getAdvancementFrame("portal-extract"), this.plugin.getConfigManager().getAdvancementParent("portal-extract"));
        try {
            Bukkit.getUnsafe().loadAdvancement(this.portalExtractKey, portalExtractJson);
            this.plugin.getLogger().info("Registered advancement: " + this.portalExtractKey.getKey());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to load portal_extract advancement (already exists?): " + e.getMessage());
        }
    }

    public void unregisterAdvancements() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.revokeAdvancement(player, this.homeReturnKey);
            this.revokeAdvancement(player, this.portalExtractKey);
        }
        Bukkit.getUnsafe().removeAdvancement(this.homeReturnKey);
        Bukkit.getUnsafe().removeAdvancement(this.portalExtractKey);
        this.plugin.getLogger().info("Unregistered custom advancements.");
    }

    private String createAdvancementJson(String title, String description, Material icon, String frame, String parent) {
        return this.gson.toJson((Object)new AdvancementJson(title, description, icon.name().toLowerCase(), frame, parent));
    }

    public void grantHomeReturnAdvancement(Player player) {
        this.grantAdvancement(player, this.homeReturnKey);
    }

    public void grantPortalExtractAdvancement(Player player) {
        this.grantAdvancement(player, this.portalExtractKey);
    }

    private void grantAdvancement(Player player, NamespacedKey key) {
        Advancement advancement = Bukkit.getAdvancement((NamespacedKey)key);
        if (advancement != null) {
            AdvancementProgress progress = player.getAdvancementProgress(advancement);
            if (!progress.isDone()) {
                for (String criteria : progress.getRemainingCriteria()) {
                    progress.awardCriteria(criteria);
                }
            }
        } else {
            this.plugin.getLogger().warning("Advancement " + key.getKey() + " not found for player " + player.getName());
        }
    }

    private void revokeAdvancement(Player player, NamespacedKey key) {
        AdvancementProgress progress;
        Advancement advancement = Bukkit.getAdvancement((NamespacedKey)key);
        if (advancement != null && (progress = player.getAdvancementProgress(advancement)).isDone()) {
            for (String criteria : progress.getAwardedCriteria()) {
                progress.revokeCriteria(criteria);
            }
        }
    }

    private static class AdvancementJson {
        Display display;
        String parent;
        Criteria criteria;

        AdvancementJson(String title, String description, String iconMaterial, String frame, String parent) {
            this.display = new Display(title, description, iconMaterial, frame);
            this.parent = parent;
            this.criteria = new Criteria();
        }
    }

    private static class Trigger {
        String trigger = "minecraft:impossible";

        private Trigger() {
        }
    }

    private static class Criteria {
        Trigger trigger = new Trigger();

        private Criteria() {
        }
    }

    private static class Icon {
        String id;

        Icon(String item) {
            this.id = "minecraft:" + item;
        }
    }

    private static class Display {
        JsonElement title;
        JsonElement description;
        Icon icon;
        String frame;
        boolean show_toast = true;
        boolean announce_to_chat = true;
        boolean hidden = false;

        Display(String title, String description, String iconMaterial, String frame) {
            this.icon = new Icon(iconMaterial);
            this.title = JsonParser.parseString((String)("{\"text\":\"" + title + "\"}"));
            this.description = JsonParser.parseString((String)("{\"text\":\"" + description + "\"}"));
            this.frame = frame;
        }
    }
}

