/*
 * Decompiled with CFR 0.152.
 */
package com.example.recallpotion.managers;

import com.example.recallpotion.RecallPotionPlugin;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final RecallPotionPlugin plugin;
    private FileConfiguration config;

    public ConfigManager(RecallPotionPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public String getMessage(String path) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("messages." + path, "&cMessage not found: " + path));
    }

    public String getAdvancementTitle(String advancement) {
        return this.config.getString("achievements." + advancement + ".title", "Default Title");
    }

    public String getAdvancementDescription(String advancement) {
        return this.config.getString("achievements." + advancement + ".description", "Default Description");
    }

    public Material getAdvancementIcon(String advancement) {
        String materialName = this.config.getString("achievements." + advancement + ".icon", "ENDER_EYE");
        try {
            return Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid material for advancement icon: " + materialName + ". Using ENDER_EYE.");
            return Material.ENDER_EYE;
        }
    }

    public String getAdvancementFrame(String advancement) {
        String frame = this.config.getString("achievements." + advancement + ".frame", "task");
        if (!(frame.equalsIgnoreCase("task") || frame.equalsIgnoreCase("challenge") || frame.equalsIgnoreCase("goal"))) {
            this.plugin.getLogger().warning("Invalid frame for advancement: " + frame + ". Using 'task'.");
            return "task";
        }
        return frame;
    }

    public String getAdvancementParent(String advancement) {
        return this.config.getString("achievements." + advancement + ".parent", "minecraft:adventure/root");
    }

    public Sound getSound(String path) {
        try {
            return Sound.valueOf((String)this.config.getString("sounds." + path, "BLOCK_NOTE_BLOCK_PLING"));
        }
        catch (IllegalArgumentException e) {
            return Sound.BLOCK_NOTE_BLOCK_PLING;
        }
    }

    public int getXpCost() {
        return this.config.getInt("settings.xp-cost", 8);
    }

    public String getPotionName() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("settings.potion-name", "&d\u0417\u0435\u043b\u044c\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430"));
    }

    public List<String> getPotionLore() {
        return this.config.getStringList("settings.potion-lore").stream().map(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line)).collect(Collectors.toList());
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }
}

