/*
 * Decompiled with CFR 0.152.
 */
package com.example.recallpotion.managers;

import com.example.recallpotion.RecallPotionPlugin;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionType;

public class RecipeManager {
    private final RecallPotionPlugin plugin;
    private NamespacedKey recallPotionKey;

    public RecipeManager(RecallPotionPlugin plugin) {
        this.plugin = plugin;
        this.recallPotionKey = new NamespacedKey((Plugin)plugin, "recall_potion");
    }

    public void registerRecipes() {
        ItemStack recallPotion = this.createRecallPotion();
        ShapedRecipe recipe = new ShapedRecipe(this.recallPotionKey, recallPotion);
        recipe.shape(new String[]{" S ", "GWE", "   "});
        recipe.setIngredient('W', Material.POTION);
        recipe.setIngredient('G', Material.SCULK);
        recipe.setIngredient('S', Material.SUNFLOWER);
        recipe.setIngredient('E', Material.ENDER_EYE);
        this.plugin.getServer().addRecipe((Recipe)recipe);
    }

    public void unregisterRecipes() {
        this.plugin.getServer().removeRecipe(this.recallPotionKey);
    }

    public ItemStack createRecallPotion() {
        ItemStack potion = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)potion.getItemMeta();
        meta.setBasePotionType(PotionType.WATER);
        meta.setDisplayName(this.plugin.getConfigManager().getPotionName());
        meta.setLore(this.plugin.getConfigManager().getPotionLore());
        meta.setCustomModelData(Integer.valueOf(12345));
        potion.setItemMeta((ItemMeta)meta);
        return potion;
    }

    public boolean isRecallPotion(ItemStack item) {
        if (item == null || item.getType() != Material.POTION) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta != null && meta.hasCustomModelData() && meta.getCustomModelData() == 12345;
    }
}

