/*
 * Decompiled with CFR 0.152.
 */
package com.padbro.greeterbro.client;

import com.padbro.greeterbro.client.JoinCache;
import com.padbro.greeterbro.client.commands.CommandManager;
import com.padbro.greeterbro.client.config.GreeterBroConfig;
import com.padbro.greeterbro.client.managers.AfkManager;
import com.padbro.greeterbro.client.managers.MigrationManager;
import com.padbro.greeterbro.client.managers.TickManager;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class GreeterBroClient
implements ClientModInitializer {
    private static ConfigHolder<GreeterBroConfig> config;
    private static JoinCache joinCache;
    public static boolean isJoining;
    public static final String MOD_ID = "GreeterBro";
    public static final Logger LOGGER;

    public static GreeterBroConfig getConfig() {
        config.save();
        return (GreeterBroConfig)config.get();
    }

    public static JoinCache getJoinCache() {
        return joinCache;
    }

    public static void saveConfig() {
        config.save();
    }

    public void onInitializeClient() {
        config = AutoConfig.register(GreeterBroConfig.class, Toml4jConfigSerializer::new);
        MigrationManager.migrate();
        joinCache = JoinCache.loadCache();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            TickManager.onTick();
            AfkManager.onTick();
        });
        CommandManager.register();
    }

    static {
        isJoining = false;
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
    }
}

