/*
 * Decompiled with CFR 0.152.
 */
package com.padbro.greeterbro.client.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.padbro.greeterbro.client.GreeterBroClient;
import com.padbro.greeterbro.client.commands.provider.BlacklistSuggestionProvider;
import com.padbro.greeterbro.client.commands.provider.PlayerSuggestionProvider;
import com.padbro.greeterbro.client.config.GreeterBroConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class BlacklistCommand {
    public static void register(LiteralArgumentBuilder<FabricClientCommandSource> root) {
        root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"blacklist").executes(BlacklistCommand::list)).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new PlayerSuggestionProvider()).executes(BlacklistCommand::add)))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new BlacklistSuggestionProvider()).executes(BlacklistCommand::remove))));
    }

    public static int list(CommandContext<FabricClientCommandSource> context) {
        GreeterBroConfig config = GreeterBroClient.getConfig();
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        String players = String.join((CharSequence)", ", config.blacklistConfig.players);
        source.sendFeedback((class_2561)class_2561.method_43469((String)"text.command.GreeterBro.blacklist.get.success", (Object[])new Object[]{config.blacklistConfig.players.size(), players}).method_27692(class_124.field_1080));
        return 0;
    }

    public static int add(CommandContext<FabricClientCommandSource> context) {
        GreeterBroConfig config = GreeterBroClient.getConfig();
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        String player = StringArgumentType.getString(context, (String)"player");
        if (config.blacklistConfig.players.contains(player)) {
            source.sendError((class_2561)class_2561.method_43471((String)"text.command.GreeterBro.blacklist.add.error.exists"));
            return 0;
        }
        config.blacklistConfig.players.add(player);
        GreeterBroClient.saveConfig();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"text.command.GreeterBro.blacklist.add.success", (Object[])new Object[]{player}).method_27692(class_124.field_1080));
        return 0;
    }

    public static int remove(CommandContext<FabricClientCommandSource> context) {
        GreeterBroConfig config = GreeterBroClient.getConfig();
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        String player = StringArgumentType.getString(context, (String)"player");
        if (!config.blacklistConfig.players.contains(player)) {
            source.sendError((class_2561)class_2561.method_43471((String)"text.command.GreeterBro.blacklist.remove.error.exists"));
            return 0;
        }
        config.blacklistConfig.players.remove(player);
        GreeterBroClient.saveConfig();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"text.command.GreeterBro.blacklist.remove.success", (Object[])new Object[]{player}).method_27692(class_124.field_1080));
        return 0;
    }
}

