/*
 * Decompiled with CFR 0.152.
 */
package com.padbro.greeterbro.client.config;

import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Config(name="general")
@Environment(value=EnvType.CLIENT)
public class GeneralConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    public int configVersion = 0;
    @ConfigEntry.Gui.Tooltip
    public boolean enable = true;
    @ConfigEntry.Gui.Tooltip
    public boolean enableOwnJoin = true;
    @ConfigEntry.Gui.Tooltip
    public String customMessage = "";
    @ConfigEntry.BoundedDiscrete(max=100L)
    @ConfigEntry.Gui.Tooltip
    public int greetingChance = 100;
    public boolean cancelOnLeave = true;
    @ConfigEntry.Gui.Tooltip
    public String customLeaveMessage = "";
    @ConfigEntry.Gui.Tooltip
    public List<String> greetings = List.of("Hello", "o/");
    @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
    public DelayRange delayRange = new DelayRange(3.0f, 5.0f);

    public void validatePostLoad() {
        float actualMin = Math.min(this.delayRange.min, this.delayRange.max);
        float actualMax = Math.max(this.delayRange.min, this.delayRange.max);
        this.delayRange.min = Math.max(actualMin, 0.0f);
        this.delayRange.max = Math.max(actualMax, 0.0f);
        this.greetings = this.greetings.stream().filter(s -> !s.trim().isEmpty()).collect(Collectors.toList());
    }

    @Environment(value=EnvType.CLIENT)
    public static class DelayRange {
        @ConfigEntry.BoundedDiscrete(max=10L, min=0L)
        public float min;
        @ConfigEntry.BoundedDiscrete(max=10L, min=0L)
        public float max;

        DelayRange(float min, float max) {
            this.min = min;
            this.max = max;
        }

        public int getRandomDelayInTicks() {
            float actualMin = Math.min(this.min, this.max);
            float actualMax = Math.max(this.min, this.max);
            float min = Math.max(actualMin, 0.0f);
            float max = Math.max(actualMax, 0.0f);
            float randomDelay = (float)(Math.random() * (double)(max - min + 1.0f)) + min;
            return Math.round(randomDelay * 20.0f);
        }
    }
}

