/*
 * Decompiled with CFR 0.152.
 */
package com.padbro.greeterbro.client.config;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Config(name="specialGreetings")
@Environment(value=EnvType.CLIENT)
public class SpecialGreetingsConfig
implements ConfigData {
    @ConfigEntry.Gui.Tooltip
    public List<SpecialGreeting> specialGreetings = List.of();

    public Optional<SpecialGreeting> getForPlayer(String player) {
        return this.specialGreetings.stream().filter(specialGreeting -> player.equals(specialGreeting.player)).findFirst();
    }

    public void validatePostLoad() {
        this.specialGreetings = this.specialGreetings.stream().filter(specialGreeting -> {
            if (Objects.equals(specialGreeting.player, "")) {
                return false;
            }
            specialGreeting.greetings = specialGreeting.greetings.stream().filter(s -> !s.trim().isEmpty()).toList();
            specialGreeting.returningGreetings = specialGreeting.returningGreetings.stream().filter(s -> !s.trim().isEmpty()).toList();
            return true;
        }).toList();
    }

    @Environment(value=EnvType.CLIENT)
    public static class SpecialGreeting {
        @ConfigEntry.Gui.Tooltip
        String player = "";
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(max=100L)
        public int greetingChance = 100;
        @ConfigEntry.Gui.Tooltip
        public List<String> greetings = List.of("Good to see you", "I was waiting for you");
        @ConfigEntry.Gui.Tooltip
        public List<String> returningGreetings = List.of("You are back :D", "Where have you been?");

        SpecialGreeting() {
        }
    }
}

