/*
 * Decompiled with CFR 0.152.
 */
package com.padbro.greeterbro.client.managers;

import com.padbro.greeterbro.client.GreeterBroClient;
import com.padbro.greeterbro.client.config.AfkConfig;
import com.padbro.greeterbro.client.config.AfkNotifyType;
import com.padbro.greeterbro.client.config.GeneralConfig;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class AfkManager {
    private static final class_310 minecraftInstance = class_310.method_1551();
    public static boolean isAfk = false;
    static GeneralConfig config = GreeterBroClient.getConfig().generalConfig;
    static AfkConfig afkConfig = GreeterBroClient.getConfig().afkConfig;
    private static double previousPitch;
    private static double previousYaw;
    private static Instant lastActiveAt;

    public static void onTick() {
        if (!AfkManager.config.enable || !AfkManager.afkConfig.enable) {
            return;
        }
        if (AfkManager.isPlayerActive()) {
            AfkManager.setLastActiveNow(true);
            return;
        }
        if (isAfk) {
            return;
        }
        boolean isBefore = lastActiveAt.isBefore(Instant.now().minus(AfkManager.afkConfig.afkTime, ChronoUnit.MINUTES));
        if (isBefore) {
            AfkManager.goAfk();
        }
    }

    public static void setLastActiveNow(boolean notify) {
        lastActiveAt = Instant.now();
        if (isAfk && notify) {
            AfkManager.leaveAfk();
        }
    }

    public static void goAfk() {
        AfkManager.notifyPlayer(class_2561.method_43471((String)"text.message.GreeterBro.afk.enter_afk"));
        isAfk = true;
    }

    public static void leaveAfk() {
        AfkManager.notifyPlayer(class_2561.method_43471((String)"text.message.GreeterBro.afk.leave_afk"));
        isAfk = false;
    }

    private static void notifyPlayer(class_5250 message) {
        if (AfkManager.afkConfig.notifyType == AfkNotifyType.Disabled) {
            return;
        }
        class_746 player = AfkManager.minecraftInstance.field_1724;
        if (player != null) {
            class_124 format = AfkManager.afkConfig.notifyType == AfkNotifyType.Overlay ? class_124.field_1054 : class_124.field_1080;
            player.method_7353((class_2561)message.method_27692(format), AfkManager.afkConfig.notifyType == AfkNotifyType.Overlay);
        }
    }

    private static boolean isPlayerActive() {
        class_1297 cameraEntity = minecraftInstance.method_1560();
        if (cameraEntity != null && (previousPitch != (double)cameraEntity.method_36455() || previousYaw != (double)cameraEntity.method_36454())) {
            previousPitch = cameraEntity.method_36455();
            previousYaw = cameraEntity.method_36454();
            return true;
        }
        return AfkManager.minecraftInstance.field_1690.field_1894.method_1434() || AfkManager.minecraftInstance.field_1690.field_1881.method_1434() || AfkManager.minecraftInstance.field_1690.field_1849.method_1434() || AfkManager.minecraftInstance.field_1690.field_1913.method_1434() || AfkManager.minecraftInstance.field_1690.field_1867.method_1434() || AfkManager.minecraftInstance.field_1690.field_1903.method_1434() || AfkManager.minecraftInstance.field_1690.field_1832.method_1434() || AfkManager.minecraftInstance.field_1690.field_1904.method_1434() || AfkManager.minecraftInstance.field_1690.field_1886.method_1434() || AfkManager.minecraftInstance.field_1690.field_1907.method_1434() || AfkManager.minecraftInstance.field_1690.field_1824.method_1434();
    }

    static {
        lastActiveAt = Instant.now();
    }
}

