/*
 * Decompiled with CFR 0.152.
 */
package com.padbro.greeterbro.client.mixin;

import com.padbro.greeterbro.client.GreeterBroClient;
import com.padbro.greeterbro.client.JoinCache;
import com.padbro.greeterbro.client.TickManager;
import com.padbro.greeterbro.client.config.GreeterBroConfig;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_7417;
import net.minecraft.class_7594;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_7594.class})
public class ChatMixin {
    @Inject(method={"onGameMessage"}, at={@At(value="HEAD")})
    public void onMessage(class_2561 message, boolean overlay, CallbackInfo ci) {
        int chance;
        String player;
        List<String> greetingList;
        GreeterBroConfig config = GreeterBroClient.getConfig();
        if (!config.generalConfig.enable || class_310.method_1551().field_1724 == null) {
            return;
        }
        String currentPlayerName = class_310.method_1551().field_1724.method_5477().getString();
        if (this.isFirstJoin(message)) {
            greetingList = config.firstJoinConfig.greetings;
            player = this.getPlayerName(message, config.firstJoinConfig.customMessage);
            chance = config.firstJoinConfig.greetingChance;
        } else if (this.isNameChange(message)) {
            greetingList = config.nameChangeConfig.greetings;
            player = this.getPlayerName(message, config.nameChangeConfig.customMessage);
            chance = config.nameChangeConfig.greetingChance;
        } else if (this.isJoinMessage(message)) {
            greetingList = config.generalConfig.greetings;
            player = this.getPlayerName(message, config.generalConfig.customMessage);
            chance = config.generalConfig.greetingChance;
        } else {
            if (this.isLeaveMessage(message) && config.generalConfig.cancelOnLeave) {
                String player2 = this.getPlayerName(message, config.generalConfig.customLeaveMessage);
                TickManager.cancelTaskByPlayerName(player2);
                return;
            }
            return;
        }
        if (player != null) {
            if (config.blacklistConfig.players.contains(player)) {
                return;
            }
            if (!config.generalConfig.enableOwnJoin && player.equals(currentPlayerName)) {
                return;
            }
            JoinCache joinCache = GreeterBroClient.getJoinCache();
            if (config.returningPlayerConfig.enable) {
                if (joinCache.hasRecentlyJoined(player)) {
                    return;
                }
                if (joinCache.hasJoined(player) && !player.equals(class_310.method_1551().field_1724.method_5477().getString())) {
                    greetingList = config.returningPlayerConfig.greetings;
                    chance = config.returningPlayerConfig.greetingChance;
                }
            }
            joinCache.add(player);
        }
        if (Math.random() > (double)chance / 100.0) {
            return;
        }
        TickManager.cancelTaskByPlayerName(player);
        List<String> finalGreetingList = greetingList;
        TickManager.scheduleTask(new TickManager.ScheduledTask(config.generalConfig.delayRange.getRandomDelay(), () -> {
            Random rand = new Random();
            String greetingTemplate = (String)finalGreetingList.get(rand.nextInt(finalGreetingList.size()));
            String greeting = greetingTemplate.replace("%player%", player != null ? player : "");
            if (!greeting.isEmpty()) {
                class_310.method_1551().field_1724.field_3944.method_45729(greeting);
            }
        }, player));
    }

    @Unique
    private String getPlayerName(class_2561 message, @Nullable String customMessage) {
        Object translatable;
        class_7417 class_74172 = message.method_10851();
        if (class_74172 instanceof class_2588 && (translatable = (class_2588)class_74172).method_11023().length > 0) {
            return translatable.method_29434(0).getString();
        }
        for (class_2561 sibling : message.method_10855()) {
            class_2588 translatable2;
            class_7417 class_74173 = sibling.method_10851();
            if (!(class_74173 instanceof class_2588) || (translatable2 = (class_2588)class_74173).method_11023().length <= 0) continue;
            return translatable2.method_29434(0).getString();
        }
        String flatMessage = message.getString();
        if (customMessage == null || customMessage.isEmpty()) {
            return null;
        }
        Pattern pattern = Pattern.compile(customMessage);
        Matcher matcher = pattern.matcher(flatMessage);
        if (matcher.matches() && matcher.groupCount() >= 1) {
            return matcher.group(1);
        }
        return null;
    }

    @Unique
    private boolean isJoinMessage(class_2561 message) {
        String joinMessageKey = "multiplayer.player.joined";
        return this.hasKey(message, joinMessageKey) || this.hasContent(message, GreeterBroClient.getConfig().generalConfig.customMessage);
    }

    @Unique
    private boolean isFirstJoin(class_2561 message) {
        if (!GreeterBroClient.getConfig().firstJoinConfig.enable) {
            return false;
        }
        return this.hasContent(message, GreeterBroClient.getConfig().firstJoinConfig.customMessage);
    }

    @Unique
    private boolean isNameChange(class_2561 message) {
        if (!GreeterBroClient.getConfig().nameChangeConfig.enable) {
            return false;
        }
        String nameChangeKey = "multiplayer.player.joined.renamed";
        return this.hasKey(message, nameChangeKey) || this.hasContent(message, GreeterBroClient.getConfig().nameChangeConfig.customMessage);
    }

    @Unique
    private boolean hasKey(class_2561 message, String key) {
        String vanishKey = "text.vanish.chat.hidden";
        class_7417 class_74172 = message.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatable = (class_2588)class_74172;
            String messageKey = translatable.method_11022();
            return Objects.equals(key, messageKey);
        }
        boolean hasKey = false;
        for (class_2561 sibling : message.method_10855()) {
            class_7417 class_74173 = sibling.method_10851();
            if (!(class_74173 instanceof class_2588)) continue;
            class_2588 translatable = (class_2588)class_74173;
            String messageKey = translatable.method_11022();
            if (Objects.equals(messageKey, vanishKey)) {
                return false;
            }
            if (!Objects.equals(messageKey, key)) continue;
            hasKey = true;
        }
        return hasKey;
    }

    @Unique
    private boolean isLeaveMessage(class_2561 message) {
        String leaveMessageKey = "multiplayer.player.left";
        return this.hasKey(message, leaveMessageKey) || this.hasContent(message, GreeterBroClient.getConfig().generalConfig.customLeaveMessage);
    }

    @Unique
    private boolean hasContent(class_2561 message, String content) {
        String messageString = message.getString().trim();
        if (Objects.equals(content, "") || Objects.equals(messageString, "")) {
            return false;
        }
        Pattern pattern = Pattern.compile(content);
        return pattern.matcher(messageString).matches();
    }
}

