/*
 * Decompiled with CFR 0.152.
 */
package com.padbro.greeterbro.client.config;

import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Config(name="general")
@Environment(value=EnvType.CLIENT)
public class GeneralConfig
implements ConfigData {
    @ConfigEntry.Gui.Tooltip
    public boolean enable = true;
    @ConfigEntry.Gui.Tooltip
    public boolean enableOwnJoin = true;
    @ConfigEntry.Gui.Tooltip
    public String customMessage = "";
    @ConfigEntry.BoundedDiscrete(max=100L)
    @ConfigEntry.Gui.Tooltip
    public int greetingChance = 100;
    @ConfigEntry.Gui.Tooltip
    public List<String> greetings = List.of("Hello", "o/");
    @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
    public DelayRange delayRange = new DelayRange(20, 60);

    public void validatePostLoad() {
        int actualMin = Math.min(this.delayRange.min, this.delayRange.max);
        int actualMax = Math.max(this.delayRange.min, this.delayRange.max);
        this.delayRange.min = actualMin;
        this.delayRange.max = actualMax;
        this.greetings = this.greetings.stream().filter(s -> !s.trim().isEmpty()).collect(Collectors.toList());
    }

    @Environment(value=EnvType.CLIENT)
    public static class DelayRange {
        @ConfigEntry.BoundedDiscrete(max=100L)
        int min;
        @ConfigEntry.BoundedDiscrete(max=100L)
        int max;

        DelayRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int getRandomDelay() {
            return (int)(Math.random() * (double)(this.max - this.min + 1)) + this.min;
        }
    }
}

