/*
 * Decompiled with CFR 0.152.
 */
package com.padbro.greeterbro.client;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.padbro.greeterbro.client.JoinCache;
import com.padbro.greeterbro.client.TickManager;
import com.padbro.greeterbro.client.commands.BlacklistAddCommand;
import com.padbro.greeterbro.client.commands.BlacklistGetCommand;
import com.padbro.greeterbro.client.commands.BlacklistRemoveCommand;
import com.padbro.greeterbro.client.commands.provider.BlacklistSuggestionProvider;
import com.padbro.greeterbro.client.commands.provider.PlayerSuggestionProvider;
import com.padbro.greeterbro.client.config.GreeterBroConfig;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class GreeterBroClient
implements ClientModInitializer {
    private static ConfigHolder<GreeterBroConfig> config;
    private static JoinCache joinCache;
    public static boolean isJoining;
    public static final String MOD_ID = "GreeterBro";
    public static final Logger LOGGER;

    public static GreeterBroConfig getConfig() {
        config.save();
        return (GreeterBroConfig)config.get();
    }

    public static JoinCache getJoinCache() {
        return joinCache;
    }

    public static void saveConfig() {
        config.save();
    }

    public void onInitializeClient() {
        config = AutoConfig.register(GreeterBroConfig.class, Toml4jConfigSerializer::new);
        joinCache = JoinCache.loadCache();
        ClientTickEvents.END_CLIENT_TICK.register(client -> TickManager.onTick());
        PlayerSuggestionProvider playerSuggestionProvider = new PlayerSuggestionProvider();
        BlacklistSuggestionProvider blacklistSuggestionProvider = new BlacklistSuggestionProvider();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"greeterBro").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"blacklist").executes((Command)new BlacklistGetCommand())).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(playerSuggestionProvider).executes((Command)new BlacklistAddCommand())))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(blacklistSuggestionProvider).executes((Command)new BlacklistRemoveCommand()))))));
    }

    static {
        isJoining = false;
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
    }
}

