/*
 * Decompiled with CFR 0.152.
 */
package com.padbro.greeterbro.client;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class TickManager {
    private static final List<ScheduledTask> tasks = new LinkedList<ScheduledTask>();

    public static void scheduleTask(ScheduledTask task) {
        tasks.add(task);
    }

    public static void cancelTaskByPlayerName(@Nullable String playerName) {
        if (playerName != null) {
            tasks.removeIf(task -> Objects.equals(task.playerName, playerName));
        }
    }

    public static void onTick() {
        for (ScheduledTask task : tasks) {
            if (task.remainingTicks <= 0) {
                task.run();
                tasks.remove(task);
                return;
            }
            --task.remainingTicks;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ScheduledTask {
        final Runnable task;
        int remainingTicks;
        String playerName;

        public ScheduledTask(int delayInTicks, Runnable task, String playerName) {
            this.task = task;
            this.remainingTicks = delayInTicks;
            this.playerName = playerName;
        }

        public void run() {
            this.task.run();
        }
    }
}

