/*
 * Decompiled with CFR 0.152.
 */
package com.example.tracesmp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class TraceSMP
extends JavaPlugin
implements Listener {
    private final Map<UUID, String> playerPowers = new HashMap<UUID, String>();
    private final Set<UUID> slowfallingEnabled = new HashSet<UUID>();
    private File playerDataFile;
    private FileConfiguration playerData;
    private final Random random = new Random();
    private static final Map<String, Color> COLOR_MAP = Map.of("RED", Color.RED, "BLUE", Color.BLUE, "BLACK", Color.BLACK, "WHITE", Color.WHITE, "GREEN", Color.LIME, "YELLOW", Color.YELLOW, "PINK", Color.FUCHSIA);
    private static final Map<String, PotionEffect> EFFECT_MAP = Map.of("RED", new PotionEffect(PotionEffectType.FIRE_RESISTANCE, Integer.MAX_VALUE, 0, true, false), "BLUE", new PotionEffect(PotionEffectType.WATER_BREATHING, Integer.MAX_VALUE, 0, true, false), "BLACK", new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, true, false), "WHITE", new PotionEffect(PotionEffectType.SLOW_FALLING, Integer.MAX_VALUE, 0, true, false), "GREEN", new PotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE, Integer.MAX_VALUE, 1, true, false), "YELLOW", new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 1, true, false), "PINK", new PotionEffect(PotionEffectType.REGENERATION, Integer.MAX_VALUE, 0, true, false));
    private final Map<UUID, Boolean> activeTrails = new HashMap<UUID, Boolean>();

    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.loadPlayerData();
        this.startParticleTask();
        this.getLogger().info("TraceSMP enabled!");
    }

    public void onDisable() {
        this.savePlayerData();
        this.getLogger().info("TraceSMP disabled, data saved.");
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        UUID id = p.getUniqueId();
        String power = this.playerData.getString(id.toString());
        if (power == null) {
            ArrayList<String> keys = new ArrayList<String>(COLOR_MAP.keySet());
            power = (String)keys.get(this.random.nextInt(keys.size()));
            this.playerData.set(id.toString(), (Object)power);
            this.savePlayerData();
        }
        this.playerPowers.put(id, power);
        this.applyEffect(p);
        p.sendMessage(String.valueOf(ChatColor.GRAY) + "You're Power Is: " + this.getChatColor(power) + power);
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        Player p = e.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.applyEffect(p), 20L);
    }

    @EventHandler
    public void onMilk(PlayerItemConsumeEvent e) {
        if (e.getItem().getType() == Material.MILK_BUCKET) {
            Player p = e.getPlayer();
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.applyEffect(p), 20L);
        }
    }

    private void applyEffect(Player p) {
        String power = this.playerPowers.get(p.getUniqueId());
        if (power == null) {
            return;
        }
        PotionEffect effect = EFFECT_MAP.get(power);
        if (effect == null) {
            return;
        }
        p.getActivePotionEffects().forEach(pe -> p.removePotionEffect(pe.getType()));
        if (power.equals("WHITE")) {
            if (this.slowfallingEnabled.contains(p.getUniqueId())) {
                p.addPotionEffect(effect);
            }
        } else {
            p.addPotionEffect(effect);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent e) {
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getEntity();
        this.activeTrails.put(p.getUniqueId(), true);
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.activeTrails.put(p.getUniqueId(), false), 400L);
    }

    private void startParticleTask() {
        new BukkitRunnable(){

            public void run() {
                for (final Player p : Bukkit.getOnlinePlayers()) {
                    Color color;
                    String power;
                    if (!TraceSMP.this.activeTrails.getOrDefault(p.getUniqueId(), false).booleanValue() || (power = TraceSMP.this.playerPowers.get(p.getUniqueId())) == null || (color = COLOR_MAP.get(power)) == null) continue;
                    final Location loc = p.getLocation().clone();
                    loc.setY(loc.getY() - 0.1);
                    final Particle.DustOptions dust = new Particle.DustOptions(color, 1.5f);
                    Location footprintLoc = loc.clone();
                    new BukkitRunnable(this){
                        int age = 0;

                        public void run() {
                            if (this.age >= 40) {
                                this.cancel();
                            }
                            p.getWorld().spawnParticle(Particle.DUST, loc.getX(), loc.getY(), loc.getZ(), 20, 0.05, 0.15, 0.05, 0.0, (Object)dust);
                            ++this.age;
                        }
                    }.runTaskTimer((Plugin)TraceSMP.this, 0L, 10L);
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 10L);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("slowfalling")) {
            if (!(sender instanceof Player)) {
                return true;
            }
            Player p = (Player)sender;
            String power = this.playerPowers.get(p.getUniqueId());
            if (!"WHITE".equals(power)) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "Only white power can use this!");
                return true;
            }
            if (this.slowfallingEnabled.contains(p.getUniqueId())) {
                this.slowfallingEnabled.remove(p.getUniqueId());
                p.removePotionEffect(PotionEffectType.SLOW_FALLING);
                p.sendMessage(String.valueOf(ChatColor.GRAY) + "Slow Falling: " + String.valueOf(ChatColor.RED) + "Disabled");
            } else {
                this.slowfallingEnabled.add(p.getUniqueId());
                p.addPotionEffect(EFFECT_MAP.get("WHITE"));
                p.sendMessage(String.valueOf(ChatColor.GRAY) + "Slow Falling: " + String.valueOf(ChatColor.GREEN) + "Enabled");
            }
            return true;
        }
        return false;
    }

    private void loadPlayerData() {
        this.playerDataFile = new File(this.getDataFolder(), "playerdata.yml");
        if (!this.playerDataFile.exists()) {
            this.playerDataFile.getParentFile().mkdirs();
            try {
                this.playerDataFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.playerData = YamlConfiguration.loadConfiguration((File)this.playerDataFile);
    }

    private void savePlayerData() {
        try {
            this.playerData.save(this.playerDataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getChatColor(String color) {
        switch (color.toUpperCase()) {
            case "RED": {
                return "\u00a7c";
            }
            case "BLUE": {
                return "\u00a79";
            }
            case "BLACK": {
                return "\u00a70";
            }
            case "WHITE": {
                return "\u00a7f";
            }
            case "GREEN": {
                return "\u00a7a";
            }
            case "YELLOW": {
                return "\u00a7e";
            }
            case "PINK": {
                return "\u00a7d";
            }
        }
        return "\u00a77";
    }
}

