/*
 * Decompiled with CFR 0.152.
 */
package com.example.traceplugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class TracePlugin
extends JavaPlugin
implements Listener {
    private final Map<UUID, Particle.DustOptions> playerColors = new HashMap<UUID, Particle.DustOptions>();
    private final Map<UUID, Boolean> activeTrails = new HashMap<UUID, Boolean>();
    private final Random random = new Random();
    private File colorFile;
    private FileConfiguration colorConfig;
    private final Map<String, Color> COLOR_MAP = Map.of("BLACK", Color.BLACK, "WHITE", Color.WHITE, "BLUE", Color.BLUE, "GREEN", Color.LIME, "YELLOW", Color.YELLOW, "PINK", Color.FUCHSIA, "RED", Color.RED);
    private final List<String> COLOR_NAMES = new ArrayList<String>(this.COLOR_MAP.keySet());

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.loadColors();
        this.getLogger().info("TracePlugin v1.2 enabled!");
        new BukkitRunnable(){

            public void run() {
                for (final Player player : Bukkit.getOnlinePlayers()) {
                    Particle.DustOptions dust;
                    if (!TracePlugin.this.activeTrails.getOrDefault(player.getUniqueId(), false).booleanValue() || (dust = TracePlugin.this.playerColors.get(player.getUniqueId())) == null || player.getVelocity().length() < 0.05) continue;
                    final Location loc = player.getLocation().clone();
                    loc.setY(loc.getY() - 0.1);
                    new BukkitRunnable(this){
                        final Location footprintLoc;
                        int ticksLived;
                        {
                            this.footprintLoc = loc.clone();
                            this.ticksLived = 0;
                        }

                        public void run() {
                            if (this.ticksLived >= 400) {
                                this.cancel();
                                return;
                            }
                            player.getWorld().spawnParticle(Particle.DUST, this.footprintLoc.getX(), this.footprintLoc.getY(), this.footprintLoc.getZ(), 5, 0.05, 0.0, 0.05, 0.0, (Object)dust);
                            ++this.ticksLived;
                        }
                    }.runTaskTimer((Plugin)TracePlugin.this, 0L, 1L);
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 5L);
    }

    public void onDisable() {
        this.saveColors();
        this.playerColors.clear();
        this.activeTrails.clear();
        this.getLogger().info("TracePlugin v1.1 disabled \u2014 colors saved.");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.colorConfig.contains(uuid.toString())) {
            String colorName = this.colorConfig.getString(uuid.toString());
            Color color = this.COLOR_MAP.getOrDefault(colorName, Color.WHITE);
            this.playerColors.put(uuid, new Particle.DustOptions(color, 1.5f));
        } else {
            String randomName = this.COLOR_NAMES.get(this.random.nextInt(this.COLOR_NAMES.size()));
            Color color = this.COLOR_MAP.get(randomName);
            this.playerColors.put(uuid, new Particle.DustOptions(color, 1.5f));
            this.colorConfig.set(uuid.toString(), (Object)randomName);
            this.saveColors();
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "[TracePlugin] Your trail color is " + this.getChatColor(randomName) + randomName);
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        UUID uuid = player.getUniqueId();
        if (!this.playerColors.containsKey(uuid)) {
            return;
        }
        this.activeTrails.put(uuid, true);
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.activeTrails.put(uuid, false), 400L);
    }

    private void loadColors() {
        this.colorFile = new File(this.getDataFolder(), "colors.yml");
        if (!this.colorFile.exists()) {
            this.colorFile.getParentFile().mkdirs();
            try {
                this.colorFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().warning("Could not create colors.yml!");
            }
        }
        this.colorConfig = YamlConfiguration.loadConfiguration((File)this.colorFile);
    }

    private void saveColors() {
        try {
            this.colorConfig.save(this.colorFile);
        }
        catch (IOException e) {
            this.getLogger().warning("Could not save colors.yml!");
            e.printStackTrace();
        }
    }

    private String getChatColor(String name) {
        return switch (name.toUpperCase()) {
            case "RED" -> "\u00a7c";
            case "BLUE" -> "\u00a79";
            case "GREEN" -> "\u00a7a";
            case "BLACK" -> "\u00a70";
            case "WHITE" -> "\u00a7f";
            case "PINK" -> "\u00a7d";
            case "YELLOW" -> "\u00a7e";
            default -> "\u00a77";
        };
    }
}

