/*
 * Decompiled with CFR 0.152.
 */
package dev.spagurder.bribery.core;

import dev.spagurder.bribery.config.Config;
import dev.spagurder.bribery.config.CurrencyConfig;
import dev.spagurder.bribery.config.EntityConfig;
import dev.spagurder.bribery.core.BriberyUtil;
import dev.spagurder.bribery.state.BribeData;
import dev.spagurder.bribery.state.BriberyState;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;

public class BribeHandler {
    public static boolean handle(LivingEntity entity, ServerPlayer player, ItemStack bribe) {
        long delta;
        EntityConfig ec;
        if (entity instanceof Villager) {
            ec = new EntityConfig("villager");
        } else if (entity instanceof IronGolem) {
            ec = new EntityConfig("golem");
        } else {
            return true;
        }
        CurrencyConfig cc = Config.CURRENCY_CONFIGS.get(bribe.getItem());
        if (cc.bribeCredit <= 0.0f) {
            if (Config.verbose) {
                player.displayClientMessage((Component)Component.literal((String)"This currency is not enabled for bribing."), true);
            }
            return false;
        }
        if (!ec.bribable()) {
            if (Config.verbose) {
                player.displayClientMessage((Component)Component.literal((String)"Entity is not bribable."), true);
            }
            return false;
        }
        BribeData state = BriberyState.getOrCreateBribeData(entity.getUUID(), player.getUUID());
        float credit = cc.bribeCredit * (float)bribe.getCount();
        state.largestBribe = (int)Math.ceil(Math.max((float)state.largestBribe, credit));
        long gameTime = BriberyUtil.overworldGameTime(entity.getServer());
        if (state.isExtorting) {
            BribeHandler.extort(entity, player, state, credit);
            return false;
        }
        if (state.isCoolingDown) {
            if (state.isBribed && (delta = gameTime - state.bribedAt) >= 0L && delta < (long)Config.acceptedCooldownSeconds * 20L) {
                if (Config.verbose) {
                    player.displayClientMessage((Component)Component.literal((String)"This entity cannot accept bribes right now."), true);
                }
                return false;
            }
            if (state.isRejected) {
                delta = gameTime - state.rejectedAt;
                if (delta >= 0L && delta < (long)Config.rejectedCooldownSeconds * 20L) {
                    if (Config.rejectedCooldownAllowAttempts) {
                        BribeHandler.reject(entity, player, state, credit);
                        return false;
                    }
                    if (Config.verbose) {
                        player.displayClientMessage((Component)Component.literal((String)"This entity cannot accept bribes right now."), true);
                    }
                }
                state.isRejected = false;
            }
            state.isCoolingDown = false;
        } else {
            state.isRejected = false;
        }
        if (Config.bribeExpiryMinutes > 0 && ((delta = gameTime - state.bribedAt) < 0L || delta >= (long)Config.bribeExpiryMinutes * 1200L)) {
            state.isBribed = false;
        }
        Random random = new Random();
        if (!state.isExtortionist) {
            float rejectionChance = Math.max(ec.rejectionChance() - cc.rejectionChanceModifier * (float)bribe.getCount(), ec.minimumRejectionChance());
            if (state.isBribed) {
                rejectionChance *= Config.alreadyBribedMultiplier;
            }
            if (random.nextFloat() < rejectionChance / 100.0f) {
                BribeHandler.reject(entity, player, state, credit);
                return false;
            }
        }
        BribeHandler.accept(entity, player, state, credit, random);
        return false;
    }

    public static void accept(LivingEntity entity, ServerPlayer player, BribeData state, float credit, Random random) {
        if (!state.isExtortionist && random.nextFloat() < Config.extortionistChance / 100.0f) {
            state.isExtortionist = true;
        }
        state.isBribed = true;
        state.isCoolingDown = true;
        state.bribedAt = BriberyUtil.overworldGameTime(entity.getServer());
        state.bribeCredits += (int)Math.ceil(credit);
        if (Config.bribeXpMultiplier > 0.0f) {
            int totalXp = (int)Math.ceil(credit * Config.bribeXpMultiplier);
            entity.level().addFreshEntity((Entity)new ExperienceOrb(entity.level(), entity.getX(), entity.getY(), entity.getZ(), totalXp));
        }
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            villager.playSound(SoundEvents.VILLAGER_YES);
            ((ServerLevel)villager.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, villager.getX(), villager.getY() + 1.0, villager.getZ(), 5, 0.5, 0.5, 0.5, 0.0);
            villager.getGossips().remove(player.getUUID(), GossipType.MAJOR_NEGATIVE);
            villager.getGossips().remove(player.getUUID(), GossipType.MINOR_NEGATIVE);
            if (Config.acceptedGossipMultiplier > 0.0f) {
                villager.getGossips().add(player.getUUID(), GossipType.TRADING, (int)(credit * Config.acceptedGossipMultiplier));
            }
        }
        player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
    }

    public static void reject(LivingEntity entity, ServerPlayer player, BribeData state, float credit) {
        state.isExtortionist = false;
        state.isExtorting = false;
        state.isBribed = false;
        state.isCoolingDown = true;
        state.isRejected = true;
        state.rejectedAt = BriberyUtil.overworldGameTime(entity.getServer());
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            villager.playSound(SoundEvents.VILLAGER_NO);
            ((ServerLevel)villager.level()).sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, villager.getX(), villager.getY() + 1.0, villager.getZ(), 5, 0.5, 0.5, 0.5, 0.0);
            if (Config.rejectedGossipMultiplier > 0.0f) {
                villager.getGossips().add(player.getUUID(), GossipType.MAJOR_NEGATIVE, (int)(credit * Config.rejectedGossipMultiplier));
                villager.setLastHurtByMob((LivingEntity)player);
            }
        }
        if (entity instanceof NeutralMob) {
            NeutralMob mob = (NeutralMob)entity;
            mob.setTarget((LivingEntity)player);
            mob.setPersistentAngerTarget(player.getUUID());
            mob.setRemainingPersistentAngerTime(12000);
        }
    }

    public static void extort(LivingEntity entity, ServerPlayer player, BribeData state, float credit) {
        state.extortionBalance = Math.max(0, state.extortionBalance - (int)Math.ceil(credit * Config.extortionPriceMultiplier));
        if (state.extortionBalance > 0) {
            player.displayClientMessage((Component)Component.empty().append(entity.getDisplayName()).append(" is demanding more payment."), true);
        } else {
            long gameTime;
            player.displayClientMessage((Component)Component.empty().append(entity.getDisplayName()).append(" is satisfied... for now."), true);
            state.isExtorting = false;
            state.extortedAt = gameTime = BriberyUtil.overworldGameTime(entity.getServer());
            state.bribedAt = gameTime;
        }
    }

    public static void cancel(LivingEntity entity, ServerPlayer player) {
        BribeData state = BriberyState.getBribeData(entity.getUUID(), player.getUUID());
        if (state == null) {
            return;
        }
        if (state.isRejected) {
            return;
        }
        if (state.isExtorting) {
            BribeHandler.reject(entity, player, state, (float)state.largestBribe * Config.extortionPriceMultiplier);
            return;
        }
        BriberyState.bribeStates.get(entity.getUUID()).remove(player.getUUID());
    }
}

