/*
 * Decompiled with CFR 0.152.
 */
package dev.spagurder.bribery.mixin;

import dev.spagurder.bribery.state.BribeData;
import dev.spagurder.bribery.state.BriberyState;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public class ServerPlayerMixin {
    @Inject(method={"die"}, at={@At(value="HEAD")})
    public void beforeDie(DamageSource damageSource, CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        if (!player.serverLevel().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES)) {
            return;
        }
        Entity entity = damageSource.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        BribeData state = BriberyState.getBribeData(entity2.getUUID(), player.getUUID());
        if (state == null) {
            return;
        }
        if (state.isRejected) {
            player.getServer().getPlayerList().broadcastSystemMessage((Component)Component.empty().append(player.getDisplayName()).append(" tried to bribe ").append(entity2.getDisplayName()), false);
        }
    }
}

