package dev.spagurder.bribery.mixin.compat;

import dev.spagurder.bribery.state.BribeData;
import dev.spagurder.bribery.state.BriberyState;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(targets = "io.github.mortuusars.thief.world.Witness")
public class ThiefCompatWitnessMixin {

    @Inject(method = "isWitness", at = @At("HEAD"), cancellable = true)
    private static void beforeIsWitness(
            class_1309 criminal, class_1309 entity,
            double visibility, CallbackInfoReturnable<Boolean> cir) {
        if (criminal instanceof class_3222 player) {
            BribeData state = BriberyState.getBribeData(entity.method_5667(), player.method_5667());
            if (state != null && state.isBribed) {
                cir.setReturnValue(false);
            }
        }
    }

}
