/*
 * Decompiled with CFR 0.152.
 */
package dev.spagurder.bribery.core;

import dev.spagurder.bribery.config.Config;
import dev.spagurder.bribery.config.CurrencyConfig;
import dev.spagurder.bribery.config.EntityConfig;
import dev.spagurder.bribery.core.BriberyUtil;
import dev.spagurder.bribery.state.BribeData;
import dev.spagurder.bribery.state.BriberyState;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1439;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_4139;
import net.minecraft.class_5354;

public class BribeHandler {
    public static boolean handle(class_1309 entity, class_3222 player, class_1799 bribe) {
        long delta;
        EntityConfig ec;
        if (entity instanceof class_1646) {
            ec = new EntityConfig("villager");
        } else if (entity instanceof class_1439) {
            ec = new EntityConfig("golem");
        } else {
            return true;
        }
        CurrencyConfig cc = Config.CURRENCY_CONFIGS.get(bribe.method_7909());
        if (cc.bribeCredit <= 0.0f) {
            if (Config.verbose) {
                player.method_7353((class_2561)class_2561.method_43470((String)"This currency is not enabled for bribing."), true);
            }
            return false;
        }
        if (!ec.bribable()) {
            if (Config.verbose) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Entity is not bribable."), true);
            }
            return false;
        }
        BribeData state = BriberyState.getOrCreateBribeData(entity.method_5667(), player.method_5667());
        float credit = cc.bribeCredit * (float)bribe.method_7947();
        state.largestBribe = (int)Math.ceil(Math.max((float)state.largestBribe, credit));
        long gameTime = BriberyUtil.overworldGameTime(entity.method_5682());
        if (state.isExtorting) {
            BribeHandler.extort(entity, player, state, credit);
            return false;
        }
        if (state.isCoolingDown) {
            if (state.isBribed && (delta = gameTime - state.bribedAt) >= 0L && delta < (long)Config.acceptedCooldownSeconds * 20L) {
                if (Config.verbose) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"This entity cannot accept bribes right now."), true);
                }
                return false;
            }
            if (state.isRejected) {
                delta = gameTime - state.rejectedAt;
                if (delta >= 0L && delta < (long)Config.rejectedCooldownSeconds * 20L) {
                    if (Config.rejectedCooldownAllowAttempts) {
                        BribeHandler.reject(entity, player, state, credit);
                        return false;
                    }
                    if (Config.verbose) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"This entity cannot accept bribes right now."), true);
                    }
                }
                state.isRejected = false;
            }
            state.isCoolingDown = false;
        } else {
            state.isRejected = false;
        }
        if (Config.bribeExpiryMinutes > 0 && ((delta = gameTime - state.bribedAt) < 0L || delta >= (long)Config.bribeExpiryMinutes * 1200L)) {
            state.isBribed = false;
        }
        Random random = new Random();
        if (!state.isExtortionist) {
            float rejectionChance = Math.max(ec.rejectionChance() - cc.rejectionChanceModifier * (float)bribe.method_7947(), ec.minimumRejectionChance());
            if (state.isBribed) {
                rejectionChance *= Config.alreadyBribedMultiplier;
            }
            if (random.nextFloat() < rejectionChance / 100.0f) {
                BribeHandler.reject(entity, player, state, credit);
                return false;
            }
        }
        BribeHandler.accept(entity, player, state, credit, random);
        return false;
    }

    public static void accept(class_1309 entity, class_3222 player, BribeData state, float credit, Random random) {
        if (!state.isExtortionist && random.nextFloat() < Config.extortionistChance / 100.0f) {
            state.isExtortionist = true;
        }
        state.isBribed = true;
        state.isCoolingDown = true;
        state.bribedAt = BriberyUtil.overworldGameTime(entity.method_5682());
        state.bribeCredits += (int)Math.ceil(credit);
        if (Config.bribeXpMultiplier > 0.0f) {
            int totalXp = (int)Math.ceil(credit * Config.bribeXpMultiplier);
            entity.method_37908().method_8649((class_1297)new class_1303(entity.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321(), totalXp));
        }
        if (entity instanceof class_1646) {
            class_1646 villager = (class_1646)entity;
            villager.method_43077(class_3417.field_14815);
            ((class_3218)villager.method_37908()).method_65096((class_2394)class_2398.field_11211, villager.method_23317(), villager.method_23318() + 1.0, villager.method_23321(), 5, 0.5, 0.5, 0.5, 0.0);
            villager.method_21651().method_35124(player.method_5667(), class_4139.field_18424);
            villager.method_21651().method_35124(player.method_5667(), class_4139.field_18425);
            if (Config.acceptedGossipMultiplier > 0.0f) {
                villager.method_21651().method_19072(player.method_5667(), class_4139.field_18428, (int)(credit * Config.acceptedGossipMultiplier));
            }
        }
        player.method_6122(class_1268.field_5808, class_1799.field_8037);
    }

    public static void reject(class_1309 entity, class_3222 player, BribeData state, float credit) {
        state.isExtortionist = false;
        state.isExtorting = false;
        state.isBribed = false;
        state.isCoolingDown = true;
        state.isRejected = true;
        state.rejectedAt = BriberyUtil.overworldGameTime(entity.method_5682());
        if (entity instanceof class_1646) {
            class_1646 villager = (class_1646)entity;
            villager.method_43077(class_3417.field_15008);
            ((class_3218)villager.method_37908()).method_65096((class_2394)class_2398.field_11231, villager.method_23317(), villager.method_23318() + 1.0, villager.method_23321(), 5, 0.5, 0.5, 0.5, 0.0);
            if (Config.rejectedGossipMultiplier > 0.0f) {
                villager.method_21651().method_19072(player.method_5667(), class_4139.field_18424, (int)(credit * Config.rejectedGossipMultiplier));
                villager.method_6015((class_1309)player);
            }
        }
        if (entity instanceof class_5354) {
            class_5354 mob = (class_5354)entity;
            mob.method_5980((class_1309)player);
            mob.method_29513(player.method_5667());
            mob.method_29514(12000);
        }
    }

    public static void extort(class_1309 entity, class_3222 player, BribeData state, float credit) {
        state.extortionBalance = Math.max(0, state.extortionBalance - (int)Math.ceil(credit * Config.extortionPriceMultiplier));
        if (state.extortionBalance > 0) {
            player.method_7353((class_2561)class_2561.method_43470((String)(String.valueOf(entity.method_5476()) + " is demanding more payment.")), true);
        } else {
            long gameTime;
            player.method_7353((class_2561)class_2561.method_43470((String)(String.valueOf(entity.method_5476()) + " is satisfied... for now.")), true);
            state.isExtorting = false;
            state.extortedAt = gameTime = BriberyUtil.overworldGameTime(entity.method_5682());
            state.bribedAt = gameTime;
        }
    }

    public static void cancel(class_1309 entity, class_3222 player) {
        BribeData state = BriberyState.getBribeData(entity.method_5667(), player.method_5667());
        if (state == null) {
            return;
        }
        if (state.isExtorting) {
            BribeHandler.reject(entity, player, state, (float)state.largestBribe * Config.extortionPriceMultiplier);
            return;
        }
        BriberyState.bribeStates.get(entity.method_5667()).remove(player.method_5667());
    }
}

