/*
 * Decompiled with CFR 0.152.
 */
package dev.spagurder.bribery.core;

import dev.spagurder.bribery.config.Config;
import dev.spagurder.bribery.core.BribeHandler;
import dev.spagurder.bribery.core.BriberyUtil;
import dev.spagurder.bribery.state.BribeData;
import dev.spagurder.bribery.state.BriberyState;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class TickHandler {
    private static final Queue<BribeKey> pendingBribes = new ArrayDeque<BribeKey>();

    public static void onTick(MinecraftServer server) {
        TickHandler.processNextBribeState(server);
    }

    private static void refreshBribeQueue() {
        pendingBribes.clear();
        BriberyState.bribeStates.forEach((entityUUID, entityStates) -> {
            if (entityStates.isEmpty()) {
                pendingBribes.add(new BribeKey((UUID)entityUUID, null));
            } else {
                entityStates.forEach((playerUUID, state) -> pendingBribes.add(new BribeKey((UUID)entityUUID, (UUID)playerUUID)));
            }
        });
    }

    private static void processNextBribeState(MinecraftServer server) {
        BribeKey key = pendingBribes.poll();
        if (key == null) {
            TickHandler.refreshBribeQueue();
            return;
        }
        Map<UUID, BribeData> entityStates = BriberyState.bribeStates.get(key.entityUUID);
        if (entityStates == null) {
            return;
        }
        if (key.playerUUID == null) {
            if (entityStates.isEmpty()) {
                BriberyState.bribeStates.remove(key.entityUUID);
            }
            return;
        }
        BribeData state = entityStates.get(key.playerUUID);
        if (state == null) {
            return;
        }
        TickHandler.processBribeData(() -> entityStates.remove(key.playerUUID), server, key.entityUUID, key.playerUUID, state);
    }

    private static void processBribeData(Runnable remove, MinecraftServer server, UUID entityUUID, UUID playerUUID, BribeData state) {
        long delta;
        long gameTime = BriberyUtil.overworldGameTime(server);
        if (state.isExtortionist) {
            long hardDelta = gameTime - state.bribedAt;
            if (hardDelta < 0L || hardDelta >= (long)Config.hardExpiryDays * 28800L) {
                remove.run();
                return;
            }
            LivingEntity entity = (LivingEntity)BriberyUtil.findEntity(server, entityUUID);
            if (entity == null) {
                return;
            }
            ServerPlayer player = BriberyUtil.findPlayer(server, playerUUID);
            if (player == null) {
                return;
            }
            long delta2 = gameTime - state.extortedAt;
            if (state.isExtorting) {
                if (delta2 >= 0L && delta2 < (long)Config.extortionDeadlineMinutes) {
                    ((ServerLevel)entity.level()).sendParticles((ParticleOptions)ParticleTypes.SMOKE, entity.getX(), entity.getY() + 1.0, entity.getZ(), 1, 0.1, 0.1, 0.1, 0.005);
                    return;
                }
                state.isExtortionist = false;
                state.isExtorting = false;
                state.extortedAt = 0L;
                int extortionBalance = state.extortionBalance;
                state.extortionBalance = 0;
                BribeHandler.reject(entity, player, state, extortionBalance);
            } else if (!(delta2 >= 0L && delta2 <= (long)Config.extortionTimeMinutes || !BriberyUtil.inProximitySqr((Entity)entity, (Entity)player, Config.extortionDetectionRangeSqr) || Config.extortionRequiresLineOfSight && !entity.hasLineOfSight((Entity)player))) {
                state.isExtorting = true;
                state.extortedAt = gameTime;
                state.extortionBalance = state.largestBribe;
                player.displayClientMessage((Component)Component.literal((String)(String.valueOf(entity.getDisplayName()) + " has demanded additional payment...\nYou have " + Config.extortionTimeMinutes + " minutes to pay... or else...")), false);
            }
        } else if (state.isBribed) {
            long delta3;
            if (Config.bribeExpiryMinutes > 0 && ((delta3 = gameTime - state.bribedAt) < 0L || delta3 >= (long)Config.bribeExpiryMinutes * 1200L)) {
                remove.run();
            }
        } else if (state.isRejected && ((delta = gameTime - state.rejectedAt) < 0L || delta >= (long)Config.rejectedCooldownSeconds * 20L)) {
            remove.run();
        }
    }

    private record BribeKey(UUID entityUUID, @Nullable UUID playerUUID) {
    }
}

