/*
 * Decompiled with CFR 0.152.
 */
package dev.spagurder.bribery.mixin;

import dev.spagurder.bribery.config.Config;
import dev.spagurder.bribery.core.BribeHandler;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"hurtServer"}, at={@At(value="HEAD")}, cancellable=true)
    public void beforeHurt(ServerLevel serverLevel, DamageSource damageSource, float f, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity damagingEntity;
        Entity entity = damageSource.getEntity();
        if (entity instanceof LivingEntity && (damagingEntity = (LivingEntity)entity) instanceof ServerPlayer) {
            ItemStack bribe;
            ServerPlayer player = (ServerPlayer)damagingEntity;
            LivingEntity entity2 = (LivingEntity)this;
            if (player.isShiftKeyDown() && Config.CURRENCY_CONFIGS.containsKey((bribe = player.getMainHandItem()).getItem())) {
                cir.setReturnValue((Object)BribeHandler.handle(entity2, player, bribe));
                return;
            }
            BribeHandler.cancel(entity2, player);
        }
    }
}

