/*
 * Decompiled with CFR 0.152.
 */
package dev.spagurder.bribery.neoforge;

import dev.spagurder.bribery.Bribery;
import dev.spagurder.bribery.client.KeyMappings;
import dev.spagurder.bribery.core.TickHandler;
import dev.spagurder.bribery.state.BriberyState;
import eu.midnightdust.lib.config.MidnightConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@Mod(value="bribery")
@EventBusSubscriber
public class BriberyNeoforge {
    public BriberyNeoforge(IEventBus modBus, ModContainer modContainer) {
        Bribery.init();
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        BriberyState.load(event.getServer());
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
        BriberyState.save();
        BriberyState.unload();
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        TickHandler.onTick(event.getServer());
    }

    @EventBusSubscriber(modid="bribery", value={Dist.CLIENT})
    public static class ClientGameEvents {
        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            ClientGameEvents.processConfigKey();
        }

        private static void processConfigKey() {
            while (KeyMappings.CONFIG_SCREEN.consumeClick()) {
                Minecraft client = Minecraft.getInstance();
                if (client.player == null || client.level == null) {
                    return;
                }
                client.setScreen(MidnightConfig.getScreen((Screen)client.screen, (String)"bribery"));
            }
        }
    }

    @EventBusSubscriber(modid="bribery", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
            event.register(KeyMappings.CONFIG_SCREEN);
        }
    }
}

