/*
 * Decompiled with CFR 0.152.
 */
package dev.spagurder.bribery.state;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import dev.spagurder.bribery.Bribery;
import dev.spagurder.bribery.state.BribeData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import org.jetbrains.annotations.Nullable;

public class BriberyState {
    public static Map<UUID, Map<UUID, BribeData>> bribeStates;
    private static Path SAVE_FILE;
    private static final Gson GSON;

    public static BribeData getOrCreateBribeData(UUID entityUUID, UUID playerUUID) {
        return bribeStates.computeIfAbsent(entityUUID, k -> new HashMap()).computeIfAbsent(playerUUID, k -> new BribeData());
    }

    @Nullable
    public static BribeData getBribeData(UUID entityUUID, UUID playerUUID) {
        Map<UUID, BribeData> entityData = bribeStates.get(entityUUID);
        return entityData != null ? entityData.get(playerUUID) : null;
    }

    public static void load(class_3218 level) {
        Path worldPath = level.method_8503().method_27050(class_5218.field_24188);
        SAVE_FILE = worldPath.resolve("bribery").resolve("state.json");
        if (!Files.exists(SAVE_FILE, new LinkOption[0])) {
            bribeStates = new HashMap<UUID, Map<UUID, BribeData>>();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(SAVE_FILE);){
            Type type = new TypeToken<Map<UUID, Map<UUID, BribeData>>>(){}.getType();
            bribeStates = (Map)GSON.fromJson((Reader)reader, type);
            if (bribeStates != null) {
                return;
            }
        }
        catch (JsonParseException e) {
            Bribery.LOGGER.error("Invalid JSON data in bribe state file: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            Bribery.LOGGER.error("Error loading bribe states: {}", (Object)e.getMessage());
        }
        bribeStates = new HashMap<UUID, Map<UUID, BribeData>>();
    }

    public static void save() {
        if (bribeStates == null) {
            return;
        }
        try {
            Files.createDirectories(SAVE_FILE.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(SAVE_FILE, new OpenOption[0]);){
                GSON.toJson(bribeStates, (Appendable)writer);
            }
        }
        catch (IOException e) {
            Bribery.LOGGER.error("Error saving bribe states: {}", (Object)e.getMessage());
        }
    }

    public static void unload() {
        SAVE_FILE = null;
        bribeStates = null;
    }

    static {
        GSON = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
    }
}

