/*
 * Decompiled with CFR 0.152.
 */
package dev.spagurder.bribery.core;

import dev.spagurder.bribery.config.Config;
import dev.spagurder.bribery.config.CurrencyConfig;
import dev.spagurder.bribery.config.EntityConfig;
import dev.spagurder.bribery.config.TransientConfig;
import dev.spagurder.bribery.core.BriberyUtil;
import dev.spagurder.bribery.state.BribeData;
import dev.spagurder.bribery.state.BriberyState;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;

public class BribeHandler {
    public static boolean handle(LivingEntity entity, ServerPlayer player, ItemStack bribe) {
        long delta;
        EntityConfig ec;
        if (entity instanceof Villager) {
            ec = new EntityConfig("villager");
        } else if (BriberyUtil.isBribable(entity)) {
            ec = new EntityConfig("golem");
        } else {
            return true;
        }
        BribeHandler.witnessBribe(entity, player);
        CurrencyConfig cc = TransientConfig.CURRENCY_CONFIGS.get(bribe.getItem());
        if (cc.bribeCredit <= 0.0f) {
            if (Config.verbose) {
                player.displayClientMessage((Component)Component.literal((String)"This currency is not enabled for bribing."), true);
            }
            return false;
        }
        if (!ec.bribable()) {
            if (Config.verbose) {
                player.displayClientMessage((Component)Component.literal((String)"Entity is not bribable."), true);
            }
            return false;
        }
        BribeData state = BriberyState.getOrCreateBribeData(entity.getUUID(), player.getUUID());
        float credit = cc.bribeCredit * (float)bribe.getCount();
        state.largestBribe = (int)Math.ceil(Math.max((float)state.largestBribe, credit));
        long gameTime = BriberyUtil.overworldGameTime(BriberyUtil.getEntityServer(entity));
        if (state.isExtorting) {
            BribeHandler.extort(entity, player, state, credit);
            return false;
        }
        if (state.isCoolingDown) {
            if (state.isBribed && (delta = gameTime - state.bribedAt) >= 0L && delta < (long)Config.acceptedCooldownSeconds * 20L) {
                if (Config.verbose) {
                    player.displayClientMessage((Component)Component.literal((String)"This entity cannot accept bribes right now."), true);
                }
                return false;
            }
            if (state.isRejected) {
                delta = gameTime - state.rejectedAt;
                if (delta >= 0L && delta < (long)Config.rejectedCooldownSeconds * 20L) {
                    if (Config.rejectedCooldownAllowAttempts) {
                        BribeHandler.reject(entity, player, state, credit);
                        return false;
                    }
                    if (Config.verbose) {
                        player.displayClientMessage((Component)Component.literal((String)"This entity cannot accept bribes right now."), true);
                    }
                }
                state.isRejected = false;
            }
            state.isCoolingDown = false;
        } else {
            state.isRejected = false;
        }
        if (Config.bribeExpiryMinutes > 0 && ((delta = gameTime - state.bribedAt) < 0L || delta >= (long)Config.bribeExpiryMinutes * 1200L)) {
            state.isBribed = false;
        }
        Random random = new Random();
        if (!state.isExtortionist) {
            NeutralMob mob;
            float rejectionChance = Math.max(ec.rejectionChance() - cc.rejectionChanceModifier * (float)bribe.getCount(), ec.minimumRejectionChance());
            if (state.isBribed) {
                rejectionChance *= Config.alreadyBribedMultiplier;
            }
            if (entity instanceof NeutralMob && (mob = (NeutralMob)entity).isAngry()) {
                rejectionChance += Config.aggroRejectionModifier;
            }
            if (random.nextFloat() < rejectionChance / 100.0f) {
                BribeHandler.reject(entity, player, state, credit);
                return false;
            }
        }
        BribeHandler.accept(entity, player, state, credit, random);
        return false;
    }

    public static void accept(LivingEntity entity, ServerPlayer player, BribeData state, float credit, Random random) {
        NeutralMob mob;
        long gameTime = BriberyUtil.overworldGameTime(BriberyUtil.getEntityServer(entity));
        if (!state.isExtortionist && random.nextFloat() < Config.extortionistChance / 100.0f) {
            state.isExtortionist = true;
            state.extortedAt = gameTime;
        }
        state.isBribed = true;
        state.isCoolingDown = true;
        state.bribedAt = gameTime;
        state.bribeCredits += (int)Math.ceil(credit);
        if (Config.bribeXpMultiplier > 0.0f) {
            int totalXp = (int)Math.ceil(credit * Config.bribeXpMultiplier);
            entity.level().addFreshEntity((Entity)new ExperienceOrb(entity.level(), entity.getX(), entity.getY(), entity.getZ(), totalXp));
        }
        if (entity instanceof NeutralMob && (mob = (NeutralMob)entity).isAngry()) {
            mob.setTarget(null);
            mob.setPersistentAngerTarget(null);
            mob.setRemainingPersistentAngerTime(0);
        }
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            villager.playSound(SoundEvents.VILLAGER_YES);
            ((ServerLevel)villager.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, villager.getX(), villager.getY() + 1.0, villager.getZ(), 5, 0.5, 0.5, 0.5, 0.0);
            villager.getGossips().remove(player.getUUID(), GossipType.MAJOR_NEGATIVE);
            villager.getGossips().remove(player.getUUID(), GossipType.MINOR_NEGATIVE);
            if (Config.acceptedGossipMultiplier > 0.0f) {
                villager.getGossips().add(player.getUUID(), GossipType.TRADING, (int)(credit * Config.acceptedGossipMultiplier));
            }
        }
        player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
    }

    public static void reject(LivingEntity entity, ServerPlayer player, BribeData state, float credit) {
        state.isExtortionist = false;
        state.isExtorting = false;
        state.isBribed = false;
        state.isCoolingDown = true;
        state.isRejected = true;
        state.rejectedAt = BriberyUtil.overworldGameTime(BriberyUtil.getEntityServer(entity));
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            villager.playSound(SoundEvents.VILLAGER_NO);
            ((ServerLevel)villager.level()).sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, villager.getX(), villager.getY() + 1.0, villager.getZ(), 5, 0.5, 0.5, 0.5, 0.0);
            if (Config.rejectedGossipMultiplier > 0.0f) {
                villager.getGossips().add(player.getUUID(), GossipType.MAJOR_NEGATIVE, (int)(credit * Config.rejectedGossipMultiplier));
                villager.setLastHurtByMob((LivingEntity)player);
            }
        }
        if (entity instanceof NeutralMob) {
            NeutralMob mob = (NeutralMob)entity;
            BriberyUtil.makeMobAngry(mob, player);
        }
    }

    public static void extort(LivingEntity entity, ServerPlayer player, BribeData state, float credit) {
        state.extortionBalance = Math.max(0, state.extortionBalance - (int)Math.ceil(credit * Config.extortionPriceMultiplier));
        if (state.extortionBalance > 0) {
            player.displayClientMessage((Component)Component.empty().append(entity.getDisplayName()).append(" is demanding more payment."), true);
        } else {
            long gameTime;
            player.displayClientMessage((Component)Component.empty().append(entity.getDisplayName()).append(" is satisfied... for now."), true);
            state.isExtorting = false;
            state.extortedAt = gameTime = BriberyUtil.overworldGameTime(BriberyUtil.getEntityServer(entity));
            state.bribedAt = gameTime;
        }
    }

    public static void cancel(LivingEntity entity, ServerPlayer player) {
        BribeData state = BriberyState.getBribeData(entity.getUUID(), player.getUUID());
        if (state == null) {
            return;
        }
        if (state.isRejected) {
            return;
        }
        if (state.isExtorting) {
            BribeHandler.reject(entity, player, state, (float)state.largestBribe * Config.extortionPriceMultiplier);
            return;
        }
        BriberyState.bribeStates.get(entity.getUUID()).remove(player.getUUID());
    }

    public static void witnessBribe(LivingEntity entity, ServerPlayer player) {
        if (Config.witnessBribeRange <= 0.0) {
            return;
        }
        entity.level().getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(Config.witnessBribeRange), e -> e != entity && BriberyUtil.isBribable(e) && e.hasLineOfSight((Entity)player)).forEach(witness -> {
            BribeData state = BriberyState.getBribeData(witness.getUUID(), player.getUUID());
            if ((state == null || !state.isBribed) && BriberyUtil.inFOV(witness, (LivingEntity)player, Config.witnessBribeFovDegrees)) {
                if (witness instanceof Villager) {
                    Villager villager = (Villager)witness;
                    villager.getGossips().add(player.getUUID(), GossipType.MAJOR_POSITIVE, 25);
                }
                if (witness instanceof NeutralMob) {
                    NeutralMob mob = (NeutralMob)witness;
                    BriberyUtil.makeMobAngry(mob, player);
                }
            }
        });
    }
}

