package dev.spagurder.bribery.core;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5354;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;

public class BriberyUtil {

    @Nullable
    public static class_1297 findEntity(MinecraftServer server, UUID entityUUID) {
        for (class_3218 level : server.method_3738()) {
            class_1297 entity = level.method_14190(entityUUID);
            if (entity != null) return entity;
        }
        return null;
    }

    @Nullable
    public static class_3222 findPlayer(MinecraftServer server, UUID playerUUID) {
        return server.method_3760().method_14602(playerUUID);
    }

    public static boolean inProximitySqr(class_1297 e1, class_1297 e2, double distance) {
        if (e1.method_37908() != e2.method_37908()) return false;
        return e1.method_5858(e2) <= distance;
    }

    public static long overworldGameTime(MinecraftServer server) {
        return server.method_30002().method_8510();
    }

    public static void makeMobAngry(class_5354 mob, class_3222 player) {
        mob.method_5980(player);
        mob.method_29513(player.method_5667());
        mob.method_29514(12000);
    }

    public static boolean inFOV(class_1309 observer, class_1309 target, double fovDegrees) {
        class_243 observerPos = observer.method_33571();
        class_243 targetPos = target.method_33571();
        class_243 targetVector = targetPos.method_1020(observerPos).method_1029();
        class_243 lookVector = observer.method_5720().method_1029();
        double dot = lookVector.method_1026(targetVector);
        double angle = Math.acos(dot) * (180 / Math.PI);
        return angle <= (fovDegrees / 2.0);
    }

    public static boolean isBribable(class_1309 entity) {
        for (Class<? extends class_1309> clazz : BribableEntityRegistry.BRIBABLE_ENTITIES) {
            if (clazz.isInstance(entity)) return true;
        }
        return false;
    }

    public static MinecraftServer getEntityServer(class_1309 entity) {
        //? >1.21.8 {
        /*return entity.level().getServer();
        *///?} else {
        return entity.method_5682();
        //?}
    }

}
