/*
 * Decompiled with CFR 0.152.
 */
package dev.spagurder.bribery.core;

import dev.spagurder.bribery.config.Config;
import dev.spagurder.bribery.core.BribeHandler;
import dev.spagurder.bribery.state.BribeData;
import dev.spagurder.bribery.state.BriberyState;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class TickHandler {
    private static final Queue<BribeKey> pendingBribes = new ArrayDeque<BribeKey>();

    public static void onTick(class_3218 level) {
        TickHandler.processNextBribeState(level);
    }

    private static void refreshBribeQueue() {
        pendingBribes.clear();
        BriberyState.bribeStates.forEach((entityUUID, entityStates) -> {
            if (entityStates.isEmpty()) {
                pendingBribes.add(new BribeKey((UUID)entityUUID, null));
            } else {
                entityStates.forEach((playerUUID, state) -> pendingBribes.add(new BribeKey((UUID)entityUUID, (UUID)playerUUID)));
            }
        });
    }

    private static void processNextBribeState(class_3218 level) {
        BribeKey key = pendingBribes.poll();
        if (key == null) {
            TickHandler.refreshBribeQueue();
            return;
        }
        Map<UUID, BribeData> entityStates = BriberyState.bribeStates.get(key.entityUUID);
        if (entityStates == null) {
            return;
        }
        if (key.playerUUID == null) {
            if (entityStates.isEmpty()) {
                BriberyState.bribeStates.remove(key.entityUUID);
            }
            return;
        }
        BribeData state = entityStates.get(key.playerUUID);
        if (state == null) {
            return;
        }
        TickHandler.processBribeData(() -> entityStates.remove(key.playerUUID), level, key.entityUUID, key.playerUUID, state);
    }

    private static void processBribeData(Runnable remove, class_3218 level, UUID entityUUID, UUID playerUUID, BribeData state) {
        long delta;
        long gameTime = level.method_8510();
        if (state.isExtortionist) {
            long hardDelta = gameTime - state.bribedAt;
            if (hardDelta < 0L || hardDelta >= (long)Config.hardExpiryDays * 28800L) {
                remove.run();
                return;
            }
            class_1309 entity = (class_1309)level.method_14190(entityUUID);
            if (entity == null) {
                return;
            }
            class_3222 player = (class_3222)level.method_14190(playerUUID);
            if (player == null) {
                return;
            }
            long delta2 = gameTime - state.extortedAt;
            if (state.isExtorting) {
                if (delta2 >= 0L && delta2 < (long)Config.extortionDeadlineMinutes) {
                    level.method_65096((class_2394)class_2398.field_11251, entity.method_23317(), entity.method_23318() + 1.0, entity.method_23321(), 1, 0.1, 0.1, 0.1, 0.005);
                    return;
                }
                state.isExtortionist = false;
                state.isExtorting = false;
                state.extortedAt = 0L;
                int extortionBalance = state.extortionBalance;
                state.extortionBalance = 0;
                BribeHandler.reject(entity, player, state, extortionBalance);
            } else if (!(delta2 >= 0L && delta2 <= (long)Config.extortionTimeMinutes || !(entity.method_5858((class_1297)player) <= Config.extortionDetectionRangeSqr) || Config.extortionRequiresLineOfSight && !entity.method_6057((class_1297)player))) {
                state.isExtorting = true;
                state.extortedAt = gameTime;
                state.extortionBalance = state.largestBribe;
                player.method_7353((class_2561)class_2561.method_43470((String)(String.valueOf(entity.method_5476()) + " has demanded additional payment...\nYou have " + Config.extortionTimeMinutes + " minutes to pay... or else...")), false);
            }
        } else if (state.isBribed) {
            long delta3;
            if (Config.bribeExpiryMinutes > 0 && ((delta3 = gameTime - state.bribedAt) < 0L || delta3 >= (long)Config.bribeExpiryMinutes * 1200L)) {
                remove.run();
            }
        } else if (state.isRejected && ((delta = gameTime - state.rejectedAt) < 0L || delta >= (long)Config.rejectedCooldownSeconds * 20L)) {
            remove.run();
        }
    }

    private record BribeKey(UUID entityUUID, @Nullable UUID playerUUID) {
    }
}

