/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.client.rendering;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.client.rendering.BalmModels;
import net.blay09.mods.balm.common.NamespaceResolver;
import net.blay09.mods.balm.common.StaticNamespaceResolver;
import net.blay09.mods.balm.neoforge.ModBusEventRegisters;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ModelEvent;

public record NeoForgeBalmModels(NamespaceResolver namespaceResolver) implements BalmModels
{
    @Override
    public DeferredObject<BakedModel> loadModel(final ResourceLocation identifier) {
        final Registrations registrations = this.getActiveRegistrations();
        DeferredObject<BakedModel> deferredModel = new DeferredObject<BakedModel>(this, identifier){

            @Override
            public BakedModel resolve() {
                return registrations.bakedStandaloneModels.get(identifier);
            }

            @Override
            public boolean canResolve() {
                return registrations.bakedStandaloneModels.containsKey(identifier);
            }
        };
        registrations.additionalModels.add(identifier);
        return deferredModel;
    }

    private Registrations getActiveRegistrations() {
        return ModBusEventRegisters.getRegistrations(this.namespaceResolver.getDefaultNamespace(), Registrations.class);
    }

    @Override
    public BalmModels scoped(String modId) {
        return new NeoForgeBalmModels(new StaticNamespaceResolver(modId));
    }

    public static class Registrations {
        public final List<ResourceLocation> additionalModels = new ArrayList<ResourceLocation>();
        public Map<ResourceLocation, BakedModel> bakedStandaloneModels = new HashMap<ResourceLocation, BakedModel>();

        @SubscribeEvent
        public void onRegisterAdditionalModels(ModelEvent.RegisterAdditional event) {
            this.additionalModels.forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
        }

        @SubscribeEvent
        public void onBakingCompleted(ModelEvent.BakingCompleted event) {
            this.bakedStandaloneModels = event.getBakingResult().standaloneModels();
        }
    }
}

