/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.common.BalmLoadContexts;
import net.blay09.mods.balm.forge.DeferredRegisters;
import net.blay09.mods.balm.forge.ForgeBalmRuntime;
import net.blay09.mods.balm.forge.ForgeLoadContext;
import net.blay09.mods.balm.forge.ModBusEventRegisters;
import net.blay09.mods.balm.forge.capability.ForgeBalmCapabilities;
import net.blay09.mods.balm.forge.capability.ForgeCommonCapabilities;
import net.blay09.mods.balm.forge.client.ForgeBalmClient;
import net.blay09.mods.balm.forge.provider.ForgeBalmProviders;
import net.blay09.mods.balm.forge.world.ForgeBalmWorldGen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.IItemHandler;

@Mod(value="balm")
public class ForgeBalm {
    public ForgeBalm(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        BalmLoadContexts.register("balm", new ForgeLoadContext(modEventBus));
        Balm.registerModule(new ForgeCommonCapabilities());
        ((ForgeBalmRuntime)Balm.getRuntime()).initializeRuntime();
        DeferredRegisters.register("balm", modEventBus);
        ModBusEventRegisters.register("balm", modEventBus);
        ForgeBalmWorldGen.initializeBalmBiomeModifiers(modEventBus);
        modEventBus.addListener(ForgeBalmClient::onInitializeClient);
        ForgeBalmProviders providers = (ForgeBalmProviders)Balm.getProviders();
        providers.register(IItemHandler.class, new CapabilityToken<IItemHandler>(this){});
        providers.register(IFluidHandler.class, new CapabilityToken<IFluidHandler>(this){});
        providers.register(IFluidHandlerItem.class, new CapabilityToken<IFluidHandlerItem>(this){});
        providers.register(IEnergyStorage.class, new CapabilityToken<IEnergyStorage>(this){});
        providers.register(Container.class, new CapabilityToken<Container>(this){});
        providers.register(FluidTank.class, new CapabilityToken<FluidTank>(this){});
        providers.register(EnergyStorage.class, new CapabilityToken<EnergyStorage>(this){});
        ForgeBalmCapabilities capabilities = (ForgeBalmCapabilities)Balm.getCapabilities();
        capabilities.addExistingType(ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"item_handler"), IItemHandler.class, ForgeCapabilities.ITEM_HANDLER);
        capabilities.addExistingType(ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"fluid_handler"), IFluidHandler.class, ForgeCapabilities.FLUID_HANDLER);
        capabilities.addExistingType(ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"energy_storage"), IEnergyStorage.class, ForgeCapabilities.ENERGY);
    }
}

