/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.client.rendering;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.client.rendering.BalmModels;
import net.blay09.mods.balm.common.NamespaceResolver;
import net.blay09.mods.balm.common.StaticNamespaceResolver;
import net.blay09.mods.balm.forge.ModBusEventRegisters;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public record ForgeBalmModels(NamespaceResolver namespaceResolver) implements BalmModels
{
    @Override
    public DeferredObject<BakedModel> loadModel(final ResourceLocation identifier) {
        final Registrations registrations = this.getActiveRegistrations();
        DeferredObject<BakedModel> deferredModel = new DeferredObject<BakedModel>(this, identifier){

            @Override
            public BakedModel resolve() {
                return registrations.bakedStandaloneModels.get(identifier);
            }

            @Override
            public boolean canResolve() {
                return registrations.bakedStandaloneModels.containsKey(identifier);
            }
        };
        registrations.additionalModels.add(identifier);
        return deferredModel;
    }

    private Registrations getActiveRegistrations() {
        return ModBusEventRegisters.getRegistrations(this.namespaceResolver.getDefaultNamespace(), Registrations.class);
    }

    @Override
    public BalmModels scoped(String modId) {
        return new ForgeBalmModels(new StaticNamespaceResolver(modId));
    }

    public static class Registrations {
        public final List<ResourceLocation> additionalModels = new ArrayList<ResourceLocation>();
        public Map<ResourceLocation, BakedModel> bakedStandaloneModels = new HashMap<ResourceLocation, BakedModel>();

        @SubscribeEvent
        public void onRegisterAdditionalModels(ModelEvent.RegisterModelStateDefinitions event) {
            this.additionalModels.forEach(it -> event.register(it, new StateDefinition.Builder((Object)Blocks.AIR).create(Block::defaultBlockState, BlockState::new)));
        }

        @SubscribeEvent
        public void onBakingCompleted(ModelEvent.BakingCompleted event) {
            ModelManager modelManager = event.getModelManager();
            this.bakedStandaloneModels = this.additionalModels.stream().collect(Collectors.toMap(it -> it, it -> modelManager.getModel(new ModelResourceLocation(it, ""))));
        }
    }
}

