/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.common.resources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.LoadedConfig;
import net.blay09.mods.balm.api.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.api.config.schema.ConfiguredProperty;
import net.blay09.mods.balm.api.resources.BalmResourceCondition;
import net.blay09.mods.balm.api.resources.ResourceConditionContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public record ConfigResourceCondition(ResourceLocation configId, String category, String key, String value) implements BalmResourceCondition
{
    public static final MapCodec<ConfigResourceCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("config").forGetter(ConfigResourceCondition::configId), (App)Codec.STRING.fieldOf("category").orElse((Object)"").forGetter(ConfigResourceCondition::category), (App)Codec.STRING.fieldOf("key").forGetter(ConfigResourceCondition::key), (App)Codec.STRING.fieldOf("value").forGetter(ConfigResourceCondition::value)).apply((Applicative)instance, ConfigResourceCondition::new));

    @Override
    public boolean test(ResourceConditionContext context) {
        BalmConfigSchema schema = Balm.getConfig().getSchema(this.configId);
        LoadedConfig config = Balm.getConfig().getActiveConfig(schema);
        ConfiguredProperty<?> property = schema.findProperty(this.category, this.key);
        if (property != null) {
            String stringValue;
            Object rawValue = config.getRaw(property);
            if (rawValue instanceof StringRepresentable) {
                StringRepresentable stringRepresentable = (StringRepresentable)rawValue;
                stringValue = stringRepresentable.getSerializedName();
            } else {
                stringValue = rawValue.toString();
            }
            return stringValue.equals(this.value);
        }
        return false;
    }
}

