/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.event;

import com.mojang.brigadier.ParseResults;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.ChunkLoadingEvent;
import net.blay09.mods.balm.api.event.ChunkTrackingEvent;
import net.blay09.mods.balm.api.event.CommandEvent;
import net.blay09.mods.balm.api.event.CropGrowEvent;
import net.blay09.mods.balm.api.event.EntityAddedEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.ItemCraftedEvent;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.blay09.mods.balm.api.event.LivingDeathEvent;
import net.blay09.mods.balm.api.event.LivingFallEvent;
import net.blay09.mods.balm.api.event.LivingHealEvent;
import net.blay09.mods.balm.api.event.PlayerAttackEvent;
import net.blay09.mods.balm.api.event.PlayerChangedDimensionEvent;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.balm.api.event.PlayerLogoutEvent;
import net.blay09.mods.balm.api.event.PlayerRespawnEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.event.TossItemEvent;
import net.blay09.mods.balm.api.event.UseBlockEvent;
import net.blay09.mods.balm.api.event.UseItemEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.blay09.mods.balm.forge.event.ForgeBalmEvents;
import net.blay09.mods.balm.world.item.BuildCreativeModeTabContentsEvent;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.Result;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ForgeBalmCommonEvents {
    public static void registerEvents(ForgeBalmEvents events) {
        events.registerTickEvent(TickType.Server, TickPhase.Start, handler -> TickEvent.ServerTickEvent.Pre.BUS.addListener(orig -> handler.handle(ServerLifecycleHooks.getCurrentServer())));
        events.registerTickEvent(TickType.Server, TickPhase.End, handler -> TickEvent.ServerTickEvent.Post.BUS.addListener(orig -> handler.handle(ServerLifecycleHooks.getCurrentServer())));
        events.registerTickEvent(TickType.ServerLevel, TickPhase.Start, handler -> TickEvent.LevelTickEvent.Pre.BUS.addListener(orig -> {
            if (orig.side() == LogicalSide.SERVER) {
                handler.handle(orig.level());
            }
        }));
        events.registerTickEvent(TickType.ServerLevel, TickPhase.End, handler -> TickEvent.LevelTickEvent.Post.BUS.addListener(orig -> {
            if (orig.side() == LogicalSide.SERVER) {
                handler.handle(orig.level());
            }
        }));
        events.registerTickEvent(TickType.ServerPlayer, TickPhase.Start, handler -> TickEvent.PlayerTickEvent.Pre.BUS.addListener(orig -> {
            if (orig.side() == LogicalSide.SERVER) {
                handler.handle((ServerPlayer)orig.player());
            }
        }));
        events.registerTickEvent(TickType.ServerPlayer, TickPhase.End, handler -> TickEvent.PlayerTickEvent.Post.BUS.addListener(orig -> {
            if (orig.side() == LogicalSide.SERVER) {
                handler.handle((ServerPlayer)orig.player());
            }
        }));
        events.registerTickEvent(TickType.ClientEntity, TickPhase.Start, handler -> LivingEvent.LivingTickEvent.BUS.addListener(orig -> {
            if (orig.getEntity().level().isClientSide()) {
                handler.handle((Entity)orig.getEntity());
            }
        }));
        events.registerTickEvent(TickType.ClientEntity, TickPhase.End, handler -> LivingEvent.LivingTickEvent.BUS.addListener(orig -> {
            if (orig.getEntity().level().isClientSide()) {
                handler.handle((Entity)orig.getEntity());
            }
        }));
        events.registerTickEvent(TickType.ServerEntity, TickPhase.Start, handler -> LivingEvent.LivingTickEvent.BUS.addListener(orig -> {
            if (!orig.getEntity().level().isClientSide()) {
                handler.handle((Entity)orig.getEntity());
            }
        }));
        events.registerTickEvent(TickType.ServerEntity, TickPhase.End, handler -> LivingEvent.LivingTickEvent.BUS.addListener(orig -> {
            if (!orig.getEntity().level().isClientSide()) {
                handler.handle((Entity)orig.getEntity());
            }
        }));
        events.registerEvent(ServerStartingEvent.class, priority -> ServerAboutToStartEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            ServerStartingEvent event = new ServerStartingEvent(orig.getServer());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(ServerStartedEvent.class, priority -> net.minecraftforge.event.server.ServerStartedEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            ServerStartedEvent event = new ServerStartedEvent(orig.getServer());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(ServerStoppedEvent.class, priority -> net.minecraftforge.event.server.ServerStoppedEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            ServerStoppedEvent event = new ServerStoppedEvent(orig.getServer());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(UseBlockEvent.class, priority -> PlayerInteractEvent.RightClickBlock.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            UseBlockEvent event = new UseBlockEvent(orig.getEntity(), orig.getLevel(), orig.getHand(), orig.getHitVec());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCancellationResult(event.getInteractionResult());
                return true;
            }
            return false;
        }));
        events.registerEvent(UseItemEvent.class, priority -> PlayerInteractEvent.RightClickItem.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            UseItemEvent event = new UseItemEvent(orig.getEntity(), orig.getLevel(), orig.getHand());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.isCanceled()) {
                orig.setCancellationResult(event.getInteractionResult());
                return true;
            }
            return false;
        }));
        events.registerEvent(PlayerLoginEvent.class, priority -> PlayerEvent.PlayerLoggedInEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            PlayerLoginEvent event = new PlayerLoginEvent((ServerPlayer)orig.getEntity());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(PlayerLogoutEvent.class, priority -> PlayerEvent.PlayerLoggedOutEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            PlayerLogoutEvent event = new PlayerLogoutEvent((ServerPlayer)orig.getEntity());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(BreakBlockEvent.class, priority -> BlockEvent.BreakEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            BlockEntity blockEntity = orig.getLevel().getBlockEntity(orig.getPos());
            BreakBlockEvent event = new BreakBlockEvent((Level)orig.getLevel(), orig.getPlayer(), orig.getPos(), orig.getState(), blockEntity);
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            return event.isCanceled();
        }));
        events.registerEvent(PlayerRespawnEvent.class, priority -> PlayerEvent.PlayerRespawnEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            PlayerRespawnEvent event = new PlayerRespawnEvent((ServerPlayer)orig.getEntity(), (ServerPlayer)orig.getEntity());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(LivingFallEvent.class, priority -> net.minecraftforge.event.entity.living.LivingFallEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            LivingFallEvent event = new LivingFallEvent(orig.getEntity());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            if (event.getFallDamageOverride() != null) {
                orig.setDamageMultiplier(0.0f);
                event.getEntity().hurt(event.getEntity().level().damageSources().fall(), event.getFallDamageOverride().floatValue());
            }
            return event.isCanceled();
        }));
        events.registerEvent(net.blay09.mods.balm.api.event.LivingDamageEvent.class, priority -> LivingDamageEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            net.blay09.mods.balm.api.event.LivingDamageEvent event = new net.blay09.mods.balm.api.event.LivingDamageEvent(orig.getEntity(), orig.getSource(), orig.getAmount());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            orig.setAmount(event.getDamageAmount());
            return event.isCanceled();
        }));
        events.registerEvent(CropGrowEvent.Pre.class, priority -> BlockEvent.CropGrowEvent.Pre.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            LevelAccessor patt0$temp = orig.getLevel();
            if (patt0$temp instanceof Level) {
                Level level = (Level)patt0$temp;
                CropGrowEvent.Pre event = new CropGrowEvent.Pre(level, orig.getPos(), orig.getState());
                events.fireEventHandlers((EventPriority)((Object)priority), event);
                if (event.isCanceled()) {
                    orig.setResult(Result.DENY);
                }
            }
        }));
        events.registerEvent(CropGrowEvent.Post.class, priority -> BlockEvent.CropGrowEvent.Post.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            LevelAccessor patt0$temp = orig.getLevel();
            if (patt0$temp instanceof Level) {
                Level level = (Level)patt0$temp;
                CropGrowEvent.Post event = new CropGrowEvent.Post(level, orig.getPos(), orig.getState());
                events.fireEventHandlers((EventPriority)((Object)priority), event);
            }
        }));
        events.registerEvent(ChunkTrackingEvent.Start.class, priority -> ChunkWatchEvent.Watch.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            ChunkTrackingEvent.Start event = new ChunkTrackingEvent.Start(orig.getLevel(), orig.getPlayer(), orig.getPos());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(ChunkTrackingEvent.Stop.class, priority -> ChunkWatchEvent.UnWatch.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            ChunkTrackingEvent.Stop event = new ChunkTrackingEvent.Stop(orig.getLevel(), orig.getPlayer(), orig.getPos());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(TossItemEvent.class, priority -> ItemTossEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            TossItemEvent event = new TossItemEvent(orig.getPlayer(), orig.getEntity().getItem());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            return event.isCanceled();
        }));
        events.registerEvent(PlayerAttackEvent.class, priority -> AttackEntityEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            PlayerAttackEvent event = new PlayerAttackEvent(orig.getEntity(), orig.getTarget());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            return event.isCanceled();
        }));
        events.registerEvent(LivingHealEvent.class, priority -> net.minecraftforge.event.entity.living.LivingHealEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            LivingHealEvent event = new LivingHealEvent(orig.getEntity(), orig.getAmount());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            return event.isCanceled();
        }));
        events.registerEvent(PlayerChangedDimensionEvent.class, priority -> PlayerEvent.PlayerChangedDimensionEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            PlayerChangedDimensionEvent event = new PlayerChangedDimensionEvent((ServerPlayer)orig.getEntity(), (ResourceKey<Level>)orig.getFrom(), (ResourceKey<Level>)orig.getTo());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(ItemCraftedEvent.class, priority -> PlayerEvent.ItemCraftedEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            ItemCraftedEvent event = new ItemCraftedEvent(orig.getEntity(), orig.getCrafting(), orig.getContainer());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(CommandEvent.class, priority -> net.minecraftforge.event.CommandEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            CommandEvent event = new CommandEvent((ParseResults<CommandSourceStack>)orig.getParseResults());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            return event.isCanceled();
        }));
        events.registerEvent(LivingDeathEvent.class, priority -> net.minecraftforge.event.entity.living.LivingDeathEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            LivingDeathEvent event = new LivingDeathEvent(orig.getEntity(), orig.getSource());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            return event.isCanceled();
        }));
        events.registerEvent(EntityAddedEvent.class, priority -> EntityJoinLevelEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            EntityAddedEvent event = new EntityAddedEvent(orig.getEntity(), orig.getLevel());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
            return event.isCanceled();
        }));
        events.registerEvent(ChunkLoadingEvent.Load.class, priority -> ChunkEvent.Load.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            ChunkLoadingEvent.Load event = new ChunkLoadingEvent.Load(orig.getLevel(), orig.getChunk());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(ChunkLoadingEvent.Unload.class, priority -> ChunkEvent.Unload.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            ChunkLoadingEvent.Unload event = new ChunkLoadingEvent.Unload(orig.getLevel(), orig.getChunk());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(LevelLoadingEvent.Load.class, priority -> LevelEvent.Load.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            LevelLoadingEvent.Load event = new LevelLoadingEvent.Load(orig.getLevel());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(LevelLoadingEvent.Unload.class, priority -> LevelEvent.Unload.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            LevelLoadingEvent.Unload event = new LevelLoadingEvent.Unload(orig.getLevel());
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
        events.registerEvent(BuildCreativeModeTabContentsEvent.class, priority -> net.minecraftforge.event.BuildCreativeModeTabContentsEvent.BUS.addListener(ForgeBalmEvents.toForge(priority), orig -> {
            BuildCreativeModeTabContentsEvent event = new BuildCreativeModeTabContentsEvent(orig.getTab(), (CreativeModeTab.Output)orig);
            events.fireEventHandlers((EventPriority)((Object)priority), event);
        }));
    }
}

