/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.loader;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.blay09.mods.balm.api.BalmEnvironment;
import net.blay09.mods.balm.api.resources.ModResource;
import net.blay09.mods.balm.api.resources.ModResourceVisitor;
import net.blay09.mods.balm.api.resources.PathModResource;
import net.blay09.mods.balm.forge.loader.ForgeModInfo;
import net.blay09.mods.balm.loader.BalmPlatform;
import net.blay09.mods.balm.loader.ModInfo;
import net.minecraft.SharedConstants;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class ForgeBalmPlatform
implements BalmPlatform {
    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public String getModName(String modId) {
        return ModList.get().getModContainerById(modId).map(it -> it.getModInfo().getDisplayName()).orElse(modId);
    }

    @Override
    public Optional<ModInfo> getModInfo(String modId) {
        return ModList.get().getModContainerById(modId).map(ForgeModInfo::new);
    }

    @Override
    public BalmEnvironment physicalSide() {
        return switch (FMLEnvironment.dist) {
            default -> throw new MatchException(null, null);
            case Dist.CLIENT -> BalmEnvironment.CLIENT;
            case Dist.DEDICATED_SERVER -> BalmEnvironment.DEDICATED_SERVER;
        };
    }

    @Override
    public List<String> loadedPrimaryModIds() {
        return ModList.get().getMods().stream().map(IModInfo::getModId).toList();
    }

    @Override
    @Nullable
    public MinecraftServer server() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @Override
    public String name() {
        return "forge";
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return SharedConstants.IS_RUNNING_IN_IDE;
    }

    @Override
    public void visitModResources(String modId, String path, ModResourceVisitor visitor) {
        IModFileInfo modFile = ModList.get().getModFileById(modId);
        Path nioPath = modFile.getFile().findResource(new String[]{path});
        if (Files.exists(nioPath, new LinkOption[0])) {
            try (Stream<Path> walker = Files.walk(nioPath, new FileVisitOption[0]);){
                walker.forEach(childPath -> visitor.visit(new PathModResource((Path)childPath)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Optional<ModResource> lookupModResource(String modId, String path) {
        IModFileInfo modFile = ModList.get().getModFileById(modId);
        Path resource = modFile.getFile().findResource(new String[]{path});
        return Files.exists(resource, new LinkOption[0]) ? Optional.of(new PathModResource(resource)) : Optional.empty();
    }
}

