/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.common.client;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconExport {
    private static final Logger logger = LoggerFactory.getLogger(IconExport.class);

    public static void export(String filter) {
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.execute(() -> {
            TextureTarget renderTarget = null;
            try {
                renderTarget = new TextureTarget("balm_icon_export", 64, 64, true);
                CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)minecraft.player.connection.enabledFeatures(), (boolean)((Boolean)minecraft.options.operatorItemsTab().get()), (HolderLookup.Provider)minecraft.level.registryAccess());
                int colonIndex = filter.indexOf(58);
                String filterModId = colonIndex != -1 ? filter.substring(0, colonIndex) : filter;
                String filterItemId = colonIndex != -1 ? filter.substring(colonIndex + 1) : null;
                File exportFolder = new File("exports/icons/" + filterModId);
                if (!exportFolder.exists() && !exportFolder.mkdirs()) {
                    throw new RuntimeException("Failed to create export folder: " + String.valueOf(exportFolder));
                }
                GuiGraphics guiGraphics = new GuiGraphics(minecraft, minecraft.renderBuffers().bufferSource());
                for (CreativeModeTab creativeModeTab : CreativeModeTabs.allTabs()) {
                    for (ItemStack itemStack : creativeModeTab.getDisplayItems()) {
                        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
                        if (!itemId.getNamespace().equals(filterModId) || filterItemId != null && !itemId.getPath().equals(filterItemId)) continue;
                        int width = renderTarget.width;
                        int height = renderTarget.height;
                        GpuTexture colorTexture = renderTarget.getColorTexture();
                        if (colorTexture == null) {
                            throw new IllegalStateException("Tried to capture screenshot of an incomplete framebuffer");
                        }
                        GpuBuffer buffer = RenderSystem.getDevice().createBuffer(() -> "Screenshot buffer", BufferType.PIXEL_PACK, BufferUsage.STATIC_READ, width * height * colorTexture.getFormat().pixelSize());
                        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
                        RenderSystem.getDevice().createCommandEncoder().copyTextureToBuffer(colorTexture, buffer, 0, () -> {
                            try (GpuBuffer.ReadView readview = commandEncoder.readBuffer(buffer);){
                                try (NativeImage nativeImage = new NativeImage(width, height, false);){
                                    for (int y = 0; y < height; ++y) {
                                        for (int x = 0; x < width; ++x) {
                                            int color = readview.data().getInt((x + y * width) * colorTexture.getFormat().pixelSize());
                                            nativeImage.setPixelABGR(x, height - y - 1, color | 0xFF000000);
                                        }
                                    }
                                    nativeImage.writeToFile(new File(exportFolder, itemId.getPath() + ".png"));
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            buffer.close();
                        }, 0);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Failed to export icons", (Throwable)e);
            }
            finally {
                if (renderTarget != null) {
                    renderTarget.destroyBuffers();
                }
            }
        });
    }
}

