/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.client.rendering;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.client.rendering.BalmModels;
import net.blay09.mods.balm.common.NamespaceResolver;
import net.blay09.mods.balm.common.StaticNamespaceResolver;
import net.blay09.mods.balm.neoforge.ModBusEventRegisters;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;

public record NeoForgeBalmModels(NamespaceResolver namespaceResolver) implements BalmModels
{
    @Override
    public DeferredObject<BlockStateModel> loadModel(ResourceLocation identifier) {
        Registrations registrations = this.getActiveRegistrations();
        final StandaloneModelKey standaloneModelKey = new StandaloneModelKey(identifier);
        DeferredObject<BlockStateModel> deferredModel = new DeferredObject<BlockStateModel>(this, identifier){

            @Override
            public BlockStateModel resolve() {
                return (BlockStateModel)Minecraft.getInstance().getModelManager().getStandaloneModel(standaloneModelKey);
            }

            @Override
            public boolean canResolve() {
                BlockStateModel model = (BlockStateModel)Minecraft.getInstance().getModelManager().getStandaloneModel(standaloneModelKey);
                return model != null;
            }
        };
        registrations.additionalModels.add((StandaloneModelKey<BlockStateModel>)standaloneModelKey);
        return deferredModel;
    }

    private Registrations getActiveRegistrations() {
        return ModBusEventRegisters.getRegistrations(this.namespaceResolver.getDefaultNamespace(), Registrations.class);
    }

    @Override
    public BalmModels scoped(String modId) {
        return new NeoForgeBalmModels(new StaticNamespaceResolver(modId));
    }

    public static class Registrations {
        public final List<StandaloneModelKey<BlockStateModel>> additionalModels = new ArrayList<StandaloneModelKey<BlockStateModel>>();

        @SubscribeEvent
        public void onRegisterAdditionalModels(ModelEvent.RegisterStandalone event) {
            for (StandaloneModelKey<BlockStateModel> additionalModel : this.additionalModels) {
                event.register(additionalModel, (model, baker) -> {
                    TextureSlots textureSlots = model.getTopTextureSlots();
                    boolean ambientOcclusion = model.getTopAmbientOcclusion();
                    QuadCollection quadCollection = model.bakeTopGeometry(textureSlots, baker, (ModelState)BlockModelRotation.X0_Y0);
                    TextureAtlasSprite particleSprite = model.resolveParticleSprite(textureSlots, baker);
                    return new SingleVariant((BlockModelPart)new SimpleModelWrapper(quadCollection, ambientOcclusion, particleSprite));
                });
            }
        }
    }
}

