/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.config;

import java.io.File;
import java.util.Collection;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.config.LoadedConfig;
import net.blay09.mods.balm.api.config.MutableLoadedConfig;
import net.blay09.mods.balm.api.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.api.network.ConfigReflection;
import net.minecraft.resources.ResourceLocation;

public interface BalmConfig {
    public void registerConfig(BalmConfigSchema var1);

    public BalmConfigSchema getSchema(ResourceLocation var1);

    public MutableLoadedConfig getLocalConfig(ResourceLocation var1);

    public LoadedConfig getActiveConfig(ResourceLocation var1);

    public File getConfigDir();

    default public File getConfigDir(BalmConfigSchema schema) {
        return this.getConfigDir();
    }

    default public File getConfigFile(BalmConfigSchema schema) {
        ResourceLocation identifier = schema.identifier();
        return new File(this.getConfigDir(schema), identifier.getNamespace() + "-" + identifier.getPath() + ".toml");
    }

    default public MutableLoadedConfig getLocalConfig(BalmConfigSchema schema) {
        return this.getLocalConfig(schema.identifier());
    }

    public <T> void updateLocalConfig(Class<T> var1, Consumer<T> var2);

    default public LoadedConfig getActiveConfig(BalmConfigSchema schema) {
        return this.getActiveConfig(schema.identifier());
    }

    default public BalmConfigSchema registerConfig(Class<?> configDataClass) {
        BalmConfigSchema schema = ConfigReflection.schemaOf(configDataClass);
        this.registerConfig(schema);
        return schema;
    }

    default public BalmConfigSchema getSchema(Class<?> configDataClass) {
        return this.getSchema(ConfigReflection.getIdentifier(configDataClass));
    }

    default public <T> T getActiveConfig(Class<T> configDataClass) {
        LoadedConfig loadedConfig = this.getActiveConfig(this.getSchema(configDataClass));
        return ConfigReflection.of(configDataClass, loadedConfig).data();
    }

    public Collection<BalmConfigSchema> getSchemasByNamespace(String var1);

    public Collection<BalmConfigSchema> getSchemas();

    default public void saveLocalConfig(BalmConfigSchema schema) {
        this.saveLocalConfig(schema, this.getLocalConfig(schema));
    }

    public void saveLocalConfig(BalmConfigSchema var1, MutableLoadedConfig var2);

    public void onConfigAvailable(BalmConfigSchema var1, Consumer<MutableLoadedConfig> var2);

    default public <T> void onConfigAvailable(Class<T> configDataClass, Consumer<T> handler) {
        this.onConfigAvailable(this.getSchema(configDataClass), (MutableLoadedConfig config) -> handler.accept(this.getActiveConfig(configDataClass)));
    }
}

