/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.network;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.network.BalmNetworking;
import net.blay09.mods.balm.api.network.ClientboundMessageRegistration;
import net.blay09.mods.balm.api.network.MessageRegistration;
import net.blay09.mods.balm.api.network.ServerboundMessageRegistration;
import net.blay09.mods.balm.neoforge.ModBusEventRegisters;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.handling.MainThreadPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record NeoForgeBalmNetworking() implements BalmNetworking
{
    private static final Logger logger = LoggerFactory.getLogger(NeoForgeBalmNetworking.class);
    private static IPayloadContext replyContext;
    private static final Set<String> clientOnlyMods;
    private static final Set<String> serverOnlyMods;
    private static final Map<String, String> networkVersions;

    @Override
    public void allowClientOnly(String modId) {
        clientOnlyMods.add(modId);
    }

    @Override
    public void allowServerOnly(String modId) {
        serverOnlyMods.add(modId);
    }

    @Override
    public void openMenu(Player player, MenuProvider menuProvider) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (menuProvider instanceof BalmMenuProvider) {
                BalmMenuProvider balmMenuProvider = (BalmMenuProvider)menuProvider;
                this.openGui(serverPlayer, balmMenuProvider);
            } else {
                serverPlayer.openMenu(menuProvider);
            }
        }
    }

    @Override
    public void defineNetworkVersion(String modId, String version) {
        networkVersions.put(modId, version);
    }

    private <T> void openGui(ServerPlayer player, BalmMenuProvider<T> menuProvider) {
        player.openMenu(menuProvider, buf -> menuProvider.getScreenStreamCodec().encode(buf, menuProvider.getScreenOpeningData(player)));
    }

    @Override
    public <T extends CustomPacketPayload> void reply(T message) {
        if (replyContext == null) {
            throw new IllegalStateException("No context to reply to");
        }
        replyContext.reply(message);
    }

    @Override
    public <T extends CustomPacketPayload> void sendTo(Player player, T message) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public <T extends CustomPacketPayload> void sendToTracking(ServerLevel level, BlockPos pos, T message) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)new ChunkPos(pos), message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <T extends CustomPacketPayload> void sendToTracking(Entity entity, T message) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <T extends CustomPacketPayload> void sendToAll(MinecraftServer server, T message) {
        PacketDistributor.sendToAllPlayers(message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <T extends CustomPacketPayload> void sendToServer(T message) {
        if (!Balm.getProxy().isConnected()) {
            logger.debug("Skipping message {} because we're not connected to a server", message);
            return;
        }
        ClientPacketDistributor.sendToServer(message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <T extends CustomPacketPayload> void registerClientboundPacket(CustomPacketPayload.Type<T> type, Class<T> clazz, StreamCodec<RegistryFriendlyByteBuf, T> codec, BiConsumer<Player, T> handler) {
        ClientboundMessageRegistration<RegistryFriendlyByteBuf, T> messageRegistration = new ClientboundMessageRegistration<RegistryFriendlyByteBuf, T>(type, codec, handler);
        Registrations registrations = this.getActiveRegistrations(type.id().getNamespace());
        registrations.playMessagesByType.put(type, messageRegistration);
    }

    @Override
    public <T extends CustomPacketPayload> void registerServerboundPacket(CustomPacketPayload.Type<T> type, Class<T> clazz, StreamCodec<RegistryFriendlyByteBuf, T> codec, BiConsumer<ServerPlayer, T> handler) {
        ServerboundMessageRegistration<RegistryFriendlyByteBuf, T> messageRegistration = new ServerboundMessageRegistration<RegistryFriendlyByteBuf, T>(type, codec, handler);
        Registrations registrations = this.getActiveRegistrations(type.id().getNamespace());
        registrations.playMessagesByType.put(type, messageRegistration);
    }

    private Registrations getActiveRegistrations(String namespace) {
        return ModBusEventRegisters.getRegistrations(namespace, Registrations.class);
    }

    static {
        clientOnlyMods = Collections.synchronizedSet(new HashSet());
        serverOnlyMods = Collections.synchronizedSet(new HashSet());
        networkVersions = new ConcurrentHashMap<String, String>();
    }

    public static class Registrations {
        private final String modId;
        private final Map<CustomPacketPayload.Type<? extends CustomPacketPayload>, MessageRegistration<RegistryFriendlyByteBuf, ? extends CustomPacketPayload>> playMessagesByType = new ConcurrentHashMap<CustomPacketPayload.Type<? extends CustomPacketPayload>, MessageRegistration<RegistryFriendlyByteBuf, ? extends CustomPacketPayload>>();

        public Registrations(String modId) {
            this.modId = modId;
        }

        @SubscribeEvent
        public void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
            String networkVersion = networkVersions.get(this.modId);
            PayloadRegistrar registrar = event.registrar(networkVersion != null ? networkVersion : this.modId);
            if (clientOnlyMods.contains(this.modId) || serverOnlyMods.contains(this.modId)) {
                registrar = registrar.optional();
            }
            for (Map.Entry<CustomPacketPayload.Type<? extends CustomPacketPayload>, MessageRegistration<RegistryFriendlyByteBuf, ? extends CustomPacketPayload>> entry : this.playMessagesByType.entrySet()) {
                MessageRegistration<RegistryFriendlyByteBuf, ? extends CustomPacketPayload> messageRegistration = entry.getValue();
                if (messageRegistration instanceof ServerboundMessageRegistration) {
                    ServerboundMessageRegistration serverboundMessageRegistration = (ServerboundMessageRegistration)messageRegistration;
                    registrar = this.playToServer(registrar, serverboundMessageRegistration);
                    continue;
                }
                if (!(messageRegistration instanceof ClientboundMessageRegistration)) continue;
                ClientboundMessageRegistration clientboundMessageRegistration = (ClientboundMessageRegistration)messageRegistration;
                registrar = this.playToClient(registrar, clientboundMessageRegistration);
            }
        }

        private <TPayload extends CustomPacketPayload> PayloadRegistrar playToServer(PayloadRegistrar registrar, ServerboundMessageRegistration<RegistryFriendlyByteBuf, TPayload> registration) {
            return registrar.playToServer(registration.getType(), registration.getCodec(), this.createPayloadHandler(registration));
        }

        private <TPayload extends CustomPacketPayload> PayloadRegistrar playToClient(PayloadRegistrar registrar, ClientboundMessageRegistration<RegistryFriendlyByteBuf, TPayload> registration) {
            return registrar.playToClient(registration.getType(), registration.getCodec(), this.createPayloadHandler(registration));
        }

        private <TBuffer extends FriendlyByteBuf, TPayload extends CustomPacketPayload> IPayloadHandler<TPayload> createPayloadHandler(ServerboundMessageRegistration<TBuffer, TPayload> serverboundMessageRegistration) {
            return new MainThreadPayloadHandler((payload, context) -> {
                replyContext = context;
                serverboundMessageRegistration.getHandler().accept((ServerPlayer)context.player(), payload);
                replyContext = null;
            });
        }

        private <TBuffer extends FriendlyByteBuf, TPayload extends CustomPacketPayload> IPayloadHandler<TPayload> createPayloadHandler(ClientboundMessageRegistration<TBuffer, TPayload> clientboundMessageRegistration) {
            return new MainThreadPayloadHandler((payload, context) -> {
                replyContext = context;
                clientboundMessageRegistration.getHandler().accept(context.player(), payload);
                replyContext = null;
            });
        }
    }
}

