/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.world;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.world.BiomeModificationBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record NeoForgeBiomeModificationBuilder(ModifiableBiomeInfo.BiomeInfo.Builder builder) implements BiomeModificationBuilder
{
    private static final Logger logger = LoggerFactory.getLogger(NeoForgeBiomeModificationBuilder.class);

    @Override
    public void addFeature(GenerationStep.Decoration step, ResourceKey<PlacedFeature> placedFeature) {
        MinecraftServer server = Balm.platform().server();
        if (server != null) {
            Registry placedFeatures = server.registryAccess().lookupOrThrow(Registries.PLACED_FEATURE);
            this.builder.getGenerationSettings().addFeature(step, (Holder)placedFeatures.getOrThrow(placedFeature));
        } else {
            logger.error("Failed to add feature {} to biome, no server is available", placedFeature);
        }
    }
}

