/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.mixin;

import net.blay09.mods.balm.api.entity.BalmEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.ValueInput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public class EntityMixin
implements BalmEntity {
    private CompoundTag fabricBalmData = new CompoundTag();
    private CompoundTag neoforgeBalmData = new CompoundTag();

    @Inject(method={"load(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="HEAD")})
    private void load(ValueInput input, CallbackInfo callbackInfo) {
        this.fabricBalmData = input.read("BalmData", CompoundTag.CODEC).orElse(this.fabricBalmData);
        this.neoforgeBalmData = input.child("NeoForgeData").flatMap(it -> it.child("PlayerPersisted")).flatMap(it -> it.read("BalmData", CompoundTag.CODEC)).orElse(this.neoforgeBalmData);
    }

    @Override
    public CompoundTag getFabricBalmData() {
        return this.fabricBalmData;
    }

    @Override
    public void setFabricBalmData(CompoundTag tag) {
        this.fabricBalmData = tag;
    }

    @Override
    public CompoundTag getForgeBalmData() {
        throw new UnsupportedOperationException("This method should not have been called. Report this issue to Balm.");
    }

    @Override
    public void setForgeBalmData(CompoundTag tag) {
        throw new UnsupportedOperationException("This method should not have been called. Report this issue to Balm.");
    }

    @Override
    public CompoundTag getNeoForgeBalmData() {
        return this.neoforgeBalmData;
    }

    @Override
    public void setNeoForgeBalmData(CompoundTag tag) {
        this.neoforgeBalmData = tag;
    }
}

