/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.block.entity;

import java.util.Arrays;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.block.BalmBlockEntities;
import net.blay09.mods.balm.api.block.entity.BalmBlockEntityFactory;
import net.blay09.mods.balm.neoforge.DeferredRegisters;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NeoForgeBalmBlockEntities
implements BalmBlockEntities {
    @Override
    public <T extends BlockEntity> DeferredObject<BlockEntityType<T>> registerBlockEntity(ResourceLocation identifier, BalmBlockEntityFactory<T> factory, Supplier<Block[]> blocks) {
        DeferredRegister register = DeferredRegisters.get(Registries.BLOCK_ENTITY_TYPE, identifier.getNamespace());
        DeferredHolder registryObject = register.register(identifier.getPath(), () -> {
            Block[] resolvedBlocks = (Block[])blocks.get();
            return new BlockEntityType(factory::create, resolvedBlocks);
        });
        return new DeferredObject<BlockEntityType<T>>(identifier, registryObject, () -> ((DeferredHolder)registryObject).isBound());
    }

    @Override
    public <T extends BlockEntity> DeferredObject<BlockEntityType<T>> registerBlockEntity(ResourceLocation identifier, BalmBlockEntityFactory<T> factory, DeferredObject<Block> ... blocks) {
        DeferredRegister register = DeferredRegisters.get(Registries.BLOCK_ENTITY_TYPE, identifier.getNamespace());
        DeferredHolder registryObject = register.register(identifier.getPath(), () -> {
            Block[] resolvedBlocks = (Block[])Arrays.stream(blocks).map(DeferredObject::get).toArray(Block[]::new);
            return new BlockEntityType(factory::create, resolvedBlocks);
        });
        return new DeferredObject<BlockEntityType<T>>(identifier, registryObject, () -> ((DeferredHolder)registryObject).isBound());
    }
}

