/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.compat.energy;

import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;

public class RebornEnergyStorage
extends SnapshotParticipant<Long>
implements team.reborn.energy.api.EnergyStorage {
    private final EnergyStorage energyStorage;

    public RebornEnergyStorage(EnergyStorage energyStorage) {
        this.energyStorage = energyStorage;
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        this.updateSnapshots(transaction);
        return this.energyStorage.fill((int)maxAmount, false);
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        this.updateSnapshots(transaction);
        return this.energyStorage.drain((int)maxAmount, false);
    }

    public long getAmount() {
        return this.energyStorage.getEnergy();
    }

    public long getCapacity() {
        return this.energyStorage.getCapacity();
    }

    protected Long createSnapshot() {
        return this.energyStorage.getEnergy();
    }

    protected void readSnapshot(Long snapshot) {
        this.energyStorage.setEnergy(snapshot.intValue());
    }
}

