/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingDamageEvent;
import net.blay09.mods.balm.api.event.LivingFallEvent;
import net.blay09.mods.balm.api.event.LivingHealEvent;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @ModifyVariable(method={"actuallyHurt(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setAbsorptionAmount(F)V"), argsOnly=true)
    private float actuallyHurt(float damageAmount, class_3218 serverLevel, class_1282 damageSource) {
        LivingDamageEvent event = new LivingDamageEvent((class_1309)this, damageSource, damageAmount);
        Balm.getEvents().fireEvent(event);
        if (event.isCanceled()) {
            return 0.0f;
        }
        return event.getDamageAmount();
    }

    @Inject(method={"causeFallDamage(FFLnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void causeFallDamage(float distance, float damageMultiplier, class_1282 damageSource, CallbackInfoReturnable<Boolean> callbackInfo, @Share(value="eventRef") LocalRef<LivingFallEvent> eventRef) {
        LivingFallEvent event = new LivingFallEvent((class_1309)this);
        Balm.getEvents().fireEvent(event);
        if (event.isCanceled()) {
            callbackInfo.setReturnValue((Object)false);
        }
        eventRef.set((Object)event);
    }

    @WrapOperation(method={"causeFallDamage(FFLnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;calculateFallDamage(FF)I")})
    private int calculateFallDamage(class_1309 self, float fallDistance, float multiplier, Operation<Integer> operation, @Share(value="eventRef") LocalRef<LivingFallEvent> eventRef) {
        LivingFallEvent event = (LivingFallEvent)eventRef.get();
        if (event != null && event.getFallDamageOverride() != null) {
            return event.getFallDamageOverride().intValue();
        }
        return (Integer)operation.call(new Object[]{self, Float.valueOf(fallDistance), Float.valueOf(multiplier)});
    }

    @ModifyVariable(method={"heal(F)V"}, at=@At(value="HEAD"), argsOnly=true)
    private float modifyHealing(float heal) {
        class_1309 entity = (class_1309)this;
        LivingHealEvent event = new LivingHealEvent(entity, heal);
        return event.isCanceled() ? 0.0f : heal;
    }
}

